/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.query.CoordinatorRewriteContext;
import org.elasticsearch.index.shard.IndexLongFieldRange;
import org.elasticsearch.indices.DateFieldRangeInfo;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public class CoordinatorRewriteContextProvider {
    private final XContentParserConfiguration parserConfig;
    private final Client client;
    private final LongSupplier nowInMillis;
    private final Supplier<ProjectState> projectStateSupplier;
    private final Function<Index, DateFieldRangeInfo> mappingSupplier;

    public CoordinatorRewriteContextProvider(XContentParserConfiguration parserConfig, Client client, LongSupplier nowInMillis, Supplier<ProjectState> projectStateSupplier, Function<Index, DateFieldRangeInfo> mappingSupplier) {
        this.parserConfig = parserConfig;
        this.client = client;
        this.nowInMillis = nowInMillis;
        this.projectStateSupplier = projectStateSupplier;
        this.mappingSupplier = mappingSupplier;
    }

    @Nullable
    public CoordinatorRewriteContext getCoordinatorRewriteContext(Index index) {
        ProjectState projectState = this.projectStateSupplier.get();
        IndexMetadata indexMetadata = projectState.metadata().index(index);
        if (indexMetadata == null) {
            return null;
        }
        DateFieldRangeInfo dateFieldRangeInfo = this.mappingSupplier.apply(index);
        IndexLongFieldRange timestampRange = indexMetadata.getTimestampRange();
        IndexLongFieldRange eventIngestedRange = indexMetadata.getEventIngestedRange();
        DateFieldMapper.DateFieldType timestampFieldType = null;
        if (dateFieldRangeInfo != null) {
            timestampFieldType = dateFieldRangeInfo.timestampFieldType();
            if (!timestampRange.containsAllShardRanges() && (timestampRange = indexMetadata.getTimeSeriesTimestampRange(timestampFieldType)) == null && !eventIngestedRange.containsAllShardRanges()) {
                return null;
            }
        }
        return new CoordinatorRewriteContext(this.parserConfig, this.client, this.nowInMillis, dateFieldRangeInfo == null ? null : new DateFieldRangeInfo(timestampFieldType, timestampRange, dateFieldRangeInfo.eventIngestedFieldType(), eventIngestedRange), !indexMetadata.getTierPreference().isEmpty() ? indexMetadata.getTierPreference().getFirst() : "");
    }
}

