/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopDoubleAggregatorFunction;
import org.elasticsearch.compute.aggregation.TopDoubleGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopDoubleAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final int limit;
    private final boolean ascending;

    public TopDoubleAggregatorFunctionSupplier(int limit, boolean ascending) {
        this.limit = limit;
        this.ascending = ascending;
    }

    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return TopDoubleAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return TopDoubleGroupingAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public TopDoubleAggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return TopDoubleAggregatorFunction.create(driverContext, channels, this.limit, this.ascending);
    }

    @Override
    public TopDoubleGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        return TopDoubleGroupingAggregatorFunction.create(channels, driverContext, this.limit, this.ascending);
    }

    @Override
    public String describe() {
        return "top of doubles";
    }
}

