/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshAction;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.test.ESSingleNodeTestCase;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.hamcrest.Matchers;

public abstract class NativeArrayIntegrationTestCase
extends ESSingleNodeTestCase {
    public void testSynthesizeEmptyArray() throws Exception {
        Object[][] arrayValues = new Object[][]{new Object[0]};
        this.verifySyntheticArray(arrayValues);
    }

    public void testSynthesizeArrayRandom() throws Exception {
        Object[] arrayValues = new Object[NativeArrayIntegrationTestCase.randomInt(64)];
        for (int j = 0; j < arrayValues.length; ++j) {
            arrayValues[j] = this.getRandomValue();
        }
        this.verifySyntheticArray(new Object[][]{arrayValues});
    }

    public void testSynthesizeArrayInObjectFieldRandom() throws Exception {
        ArrayList<Object[]> documents = new ArrayList<Object[]>();
        int numDocs = NativeArrayIntegrationTestCase.randomIntBetween(8, 256);
        for (int i = 0; i < numDocs; ++i) {
            Object[] document = new Object[NativeArrayIntegrationTestCase.randomInt(64)];
            for (int j = 0; j < document.length; ++j) {
                document[j] = this.getRandomValue();
            }
            documents.add(document);
        }
        this.verifySyntheticArrayInObject(documents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSynthesizeArrayRandomIgnoresMalformed() throws Exception {
        NativeArrayIntegrationTestCase.assumeTrue((String)"supports ignore_malformed", (this.getMalformedValue() != null ? 1 : 0) != 0);
        int numDocs = NativeArrayIntegrationTestCase.randomIntBetween(8, 256);
        ArrayList<XContentBuilder> expectedDocuments = new ArrayList<XContentBuilder>(numDocs);
        ArrayList<XContentBuilder> inputDocuments = new ArrayList<XContentBuilder>(numDocs);
        for (int i = 0; i < numDocs; ++i) {
            boolean expectedIsArray;
            int j;
            Object[] values = new Object[NativeArrayIntegrationTestCase.randomInt(64)];
            Object[] malformed = new Object[NativeArrayIntegrationTestCase.randomInt(64)];
            for (j = 0; j < values.length; ++j) {
                values[j] = this.getRandomValue();
            }
            for (j = 0; j < malformed.length; ++j) {
                malformed[j] = this.getMalformedValue();
            }
            XContentBuilder expectedDocument = XContentFactory.jsonBuilder().startObject();
            XContentBuilder inputDocument = XContentFactory.jsonBuilder().startObject();
            boolean bl = expectedIsArray = values.length != 0 || malformed.length != 1;
            if (expectedIsArray) {
                expectedDocument.startArray("field");
            } else {
                expectedDocument.field("field");
            }
            inputDocument.startArray("field");
            int valuesIdx = 0;
            int malformedIdx = 0;
            for (int j2 = 0; j2 < values.length + malformed.length; ++j2) {
                if (j2 < values.length) {
                    expectedDocument.value(values[j2]);
                } else {
                    expectedDocument.value(malformed[j2 - values.length]);
                }
                if (valuesIdx == values.length) {
                    inputDocument.value(malformed[malformedIdx++]);
                    continue;
                }
                if (malformedIdx == malformed.length) {
                    inputDocument.value(values[valuesIdx++]);
                    continue;
                }
                if (NativeArrayIntegrationTestCase.randomBoolean()) {
                    inputDocument.value(values[valuesIdx++]);
                    continue;
                }
                inputDocument.value(malformed[malformedIdx++]);
            }
            if (expectedIsArray) {
                expectedDocument.endArray();
            }
            expectedDocument.endObject();
            inputDocument.endArray().endObject();
            expectedDocuments.add(expectedDocument);
            inputDocuments.add(inputDocument);
        }
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("properties").startObject("field");
        this.minimalMapping(mapping);
        mapping.field("ignore_malformed", true).endObject().endObject().endObject();
        IndexService indexService = this.createIndex("test-index", Settings.builder().put("index.mapping.source.mode", "synthetic").put("index.mapping.synthetic_source_keep", "arrays").build(), mapping);
        for (int i = 0; i < inputDocuments.size(); ++i) {
            XContentBuilder document = (XContentBuilder)inputDocuments.get(i);
            IndexRequest indexRequest = new IndexRequest("test-index");
            indexRequest.id("my-id-" + i);
            indexRequest.source(document);
            this.client().index(indexRequest).actionGet();
        }
        RefreshRequest refreshRequest = new RefreshRequest(new String[]{"test-index"});
        this.client().execute((ActionType)RefreshAction.INSTANCE, (ActionRequest)refreshRequest).actionGet();
        for (int i = 0; i < expectedDocuments.size(); ++i) {
            XContentBuilder document = (XContentBuilder)expectedDocuments.get(i);
            String expectedSource = Strings.toString((XContentBuilder)document);
            SearchRequest searchRequest = new SearchRequest(new String[]{"test-index"});
            searchRequest.source().query((QueryBuilder)new IdsQueryBuilder().addIds(new String[]{"my-id-" + i}));
            SearchResponse searchResponse = (SearchResponse)this.client().search(searchRequest).actionGet();
            try {
                SearchHit hit = searchResponse.getHits().getHits()[0];
                NativeArrayIntegrationTestCase.assertThat(hit.getId(), Matchers.equalTo((Object)("my-id-" + i)));
                NativeArrayIntegrationTestCase.assertThat(hit.getSourceAsString(), Matchers.equalTo((Object)expectedSource));
                continue;
            }
            finally {
                searchResponse.decRef();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSynthesizeRandomArrayInNestedContext() throws Exception {
        Object[][] arrayValues = new Object[NativeArrayIntegrationTestCase.randomIntBetween(1, 8)][NativeArrayIntegrationTestCase.randomIntBetween(2, 64)];
        for (int i = 0; i < arrayValues.length; ++i) {
            for (int j = 0; j < arrayValues[i].length; ++j) {
                arrayValues[i][j] = NativeArrayIntegrationTestCase.randomInt(10) == 0 ? null : this.getRandomValue();
            }
        }
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("properties").startObject("parent").field("type", "nested").startObject("properties").startObject("field");
        this.minimalMapping(mapping);
        mapping.endObject().endObject().endObject().endObject().endObject();
        IndexService indexService = this.createIndex("test-index", Settings.builder().put("index.mapping.source.mode", "synthetic").put("index.mapping.synthetic_source_keep", "arrays").build(), mapping);
        IndexRequest indexRequest = new IndexRequest("test-index");
        indexRequest.id("my-id-1");
        XContentBuilder source = XContentFactory.jsonBuilder().startObject().startArray("parent");
        for (Object[] arrayValue : arrayValues) {
            source.startObject().array("field", arrayValue).endObject();
        }
        source.endArray().endObject();
        indexRequest.source(source);
        indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.client().index(indexRequest).actionGet();
        XContentBuilder expectedSource = XContentFactory.jsonBuilder().startObject();
        if (arrayValues.length > 1) {
            expectedSource.startArray("parent");
        } else {
            expectedSource.field("parent");
        }
        for (Object[] arrayValue : arrayValues) {
            expectedSource.startObject();
            expectedSource.array("field", arrayValue);
            expectedSource.endObject();
        }
        if (arrayValues.length > 1) {
            expectedSource.endArray();
        }
        expectedSource.endObject();
        String expected = Strings.toString((XContentBuilder)expectedSource);
        SearchRequest searchRequest = new SearchRequest(new String[]{"test-index"});
        searchRequest.source().query((QueryBuilder)new IdsQueryBuilder().addIds(new String[]{"my-id-1"}));
        SearchResponse searchResponse = (SearchResponse)this.client().search(searchRequest).actionGet();
        try {
            SearchHit hit = searchResponse.getHits().getHits()[0];
            NativeArrayIntegrationTestCase.assertThat(hit.getId(), Matchers.equalTo((Object)"my-id-1"));
            NativeArrayIntegrationTestCase.assertThat(hit.getSourceAsString(), Matchers.equalTo((Object)expected));
        }
        finally {
            searchResponse.decRef();
        }
        NativeArrayIntegrationTestCase.assertThat(indexService.mapperService().mappingLookup().getMapper("parent.field").getOffsetFieldName(), Matchers.nullValue());
        try (Engine.Searcher searcher = indexService.getShard(0).acquireSearcher(this.getTestName());){
            DirectoryReader reader = searcher.getDirectoryReader();
            Document document = reader.storedFields().document(0);
            LinkedHashSet<String> storedFieldNames = new LinkedHashSet<String>(document.getFields().stream().map(IndexableField::name).toList());
            NativeArrayIntegrationTestCase.assertThat(storedFieldNames, Matchers.contains((Object[])new String[]{"_ignored_source"}));
            NativeArrayIntegrationTestCase.assertThat(FieldInfos.getMergedFieldInfos((IndexReader)reader).fieldInfo("parent.field.offsets"), Matchers.nullValue());
        }
    }

    protected void minimalMapping(XContentBuilder b) throws IOException {
        String fieldTypeName = this.getFieldTypeName();
        NativeArrayIntegrationTestCase.assertThat(fieldTypeName, Matchers.notNullValue());
        b.field("type", fieldTypeName);
    }

    protected abstract String getFieldTypeName();

    protected abstract Object getRandomValue();

    protected abstract Object getMalformedValue();

    protected void verifySyntheticArray(Object[][] arrays) throws IOException {
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("properties").startObject("field");
        this.minimalMapping(mapping);
        mapping.endObject().endObject().endObject();
        this.verifySyntheticArray(arrays, mapping, "_id");
    }

    protected void verifySyntheticArray(Object[][] arrays, XContentBuilder mapping, String ... expectedStoredFields) throws IOException {
        this.verifySyntheticArray(arrays, arrays, mapping, expectedStoredFields);
    }

    private XContentBuilder arrayToSource(Object[] array) throws IOException {
        XContentBuilder source = XContentFactory.jsonBuilder().startObject();
        if (array != null) {
            source.startArray("field");
            for (Object arrayValue : array) {
                source.value(arrayValue);
            }
            source.endArray();
        } else {
            source.field("field").nullValue();
        }
        return source.endObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifySyntheticArray(Object[][] inputArrays, Object[][] expectedArrays, XContentBuilder mapping, String ... expectedStoredFields) throws IOException {
        NativeArrayIntegrationTestCase.assertThat(inputArrays.length, Matchers.equalTo((Object)expectedArrays.length));
        IndexService indexService = this.createIndex("test-index", Settings.builder().put("index.mapping.source.mode", "synthetic").put("index.mapping.synthetic_source_keep", "arrays").build(), mapping);
        for (int i = 0; i < inputArrays.length; ++i) {
            IndexRequest indexRequest = new IndexRequest("test-index");
            indexRequest.id("my-id-" + i);
            XContentBuilder inputSource = this.arrayToSource(inputArrays[i]);
            indexRequest.source(inputSource);
            indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.client().index(indexRequest).actionGet();
            XContentBuilder expectedSource = this.arrayToSource(expectedArrays[i]);
            SearchRequest searchRequest = new SearchRequest(new String[]{"test-index"});
            searchRequest.source().query((QueryBuilder)new IdsQueryBuilder().addIds(new String[]{"my-id-" + i}));
            SearchResponse searchResponse = (SearchResponse)this.client().search(searchRequest).actionGet();
            try {
                SearchHit hit = searchResponse.getHits().getHits()[0];
                NativeArrayIntegrationTestCase.assertThat(hit.getId(), Matchers.equalTo((Object)("my-id-" + i)));
                NativeArrayIntegrationTestCase.assertThat(hit.getSourceAsString(), Matchers.equalTo((Object)Strings.toString((XContentBuilder)expectedSource)));
                continue;
            }
            finally {
                searchResponse.decRef();
            }
        }
        try (Engine.Searcher searcher = indexService.getShard(0).acquireSearcher(this.getTestName());){
            DirectoryReader reader = searcher.getDirectoryReader();
            for (int i = 0; i < expectedArrays.length; ++i) {
                Document document = reader.storedFields().document(i);
                LinkedHashSet<String> storedFieldNames = new LinkedHashSet<String>(document.getFields().stream().map(IndexableField::name).toList());
                NativeArrayIntegrationTestCase.assertThat(storedFieldNames, Matchers.contains((Object[])expectedStoredFields));
            }
            FieldInfo fieldInfo = FieldInfos.getMergedFieldInfos((IndexReader)reader).fieldInfo("field.offsets");
            NativeArrayIntegrationTestCase.assertThat(fieldInfo.getDocValuesType(), Matchers.equalTo((Object)DocValuesType.SORTED));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifySyntheticObjectArray(List<List<Object[]>> documents) throws IOException {
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("properties").startObject("object").startObject("properties").startObject("field");
        this.minimalMapping(mapping);
        mapping.endObject().endObject().endObject().endObject().endObject();
        IndexService indexService = this.createIndex("test-index", Settings.builder().put("index.mapping.source.mode", "synthetic").put("index.mapping.synthetic_source_keep", "arrays").build(), mapping);
        for (int i = 0; i < documents.size(); ++i) {
            List<Object[]> document = documents.get(i);
            IndexRequest indexRequest = new IndexRequest("test-index");
            indexRequest.id("my-id-" + i);
            XContentBuilder source = XContentFactory.jsonBuilder().startObject();
            source.startArray("object");
            for (Object[] arrayValue : document) {
                source.startObject();
                source.array("field", arrayValue);
                source.endObject();
            }
            source.endArray().endObject();
            String expectedSource = Strings.toString((XContentBuilder)source);
            indexRequest.source(source);
            indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.client().index(indexRequest).actionGet();
            SearchRequest searchRequest = new SearchRequest(new String[]{"test-index"});
            searchRequest.source().query((QueryBuilder)new IdsQueryBuilder().addIds(new String[]{"my-id-" + i}));
            Iterator searchResponse = (SearchResponse)this.client().search(searchRequest).actionGet();
            try {
                SearchHit hit = searchResponse.getHits().getHits()[0];
                NativeArrayIntegrationTestCase.assertThat(hit.getId(), Matchers.equalTo((Object)("my-id-" + i)));
                NativeArrayIntegrationTestCase.assertThat(hit.getSourceAsString(), Matchers.equalTo((Object)expectedSource));
                continue;
            }
            finally {
                searchResponse.decRef();
            }
        }
        indexService.getShard(0).forceMerge(new ForceMergeRequest(new String[]{"test-index"}).maxNumSegments(1));
        try (Engine.Searcher searcher = indexService.getShard(0).acquireSearcher(this.getTestName());){
            DirectoryReader reader = searcher.getDirectoryReader();
            for (int i = 0; i < documents.size(); ++i) {
                Document document = reader.storedFields().document(i);
                List<String> storedFieldNames = document.getFields().stream().map(IndexableField::name).toList();
                NativeArrayIntegrationTestCase.assertThat(storedFieldNames, Matchers.contains((Object[])new String[]{"_id", "_ignored_source"}));
                LeafReader leafReader = ((LeafReaderContext)reader.leaves().get(0)).reader();
                for (FieldInfo fieldInfo : leafReader.getFieldInfos()) {
                    String name = fieldInfo.getName();
                    NativeArrayIntegrationTestCase.assertFalse((String)("expected no field that contains [offsets] in name, but found [" + name + "]"), (boolean)name.contains("offsets"));
                }
                BinaryDocValues binaryDocValues = leafReader.getBinaryDocValues("object.field.offsets");
                NativeArrayIntegrationTestCase.assertThat(binaryDocValues, Matchers.nullValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifySyntheticArrayInObject(List<Object[]> documents) throws IOException {
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("properties").startObject("object").startObject("properties").startObject("field");
        this.minimalMapping(mapping);
        mapping.endObject().endObject().endObject().endObject().endObject();
        IndexService indexService = this.createIndex("test-index", Settings.builder().put("index.mapping.source.mode", "synthetic").put("index.mapping.synthetic_source_keep", "arrays").build(), mapping);
        for (int i = 0; i < documents.size(); ++i) {
            Object[] arrayValue = documents.get(i);
            IndexRequest indexRequest = new IndexRequest("test-index");
            indexRequest.id("my-id-" + i);
            XContentBuilder source = XContentFactory.jsonBuilder().startObject();
            source.startObject("object");
            source.array("field", arrayValue);
            source.endObject().endObject();
            String expectedSource = Strings.toString((XContentBuilder)source);
            indexRequest.source(source);
            indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.client().index(indexRequest).actionGet();
            SearchRequest searchRequest = new SearchRequest(new String[]{"test-index"});
            searchRequest.source().query((QueryBuilder)new IdsQueryBuilder().addIds(new String[]{"my-id-" + i}));
            SearchResponse searchResponse = (SearchResponse)this.client().search(searchRequest).actionGet();
            try {
                SearchHit hit = searchResponse.getHits().getHits()[0];
                NativeArrayIntegrationTestCase.assertThat(hit.getId(), Matchers.equalTo((Object)("my-id-" + i)));
                NativeArrayIntegrationTestCase.assertThat(hit.getSourceAsString(), Matchers.equalTo((Object)expectedSource));
                continue;
            }
            finally {
                searchResponse.decRef();
            }
        }
        indexService.getShard(0).forceMerge(new ForceMergeRequest(new String[]{"test-index"}).maxNumSegments(1));
        try (Engine.Searcher searcher = indexService.getShard(0).acquireSearcher(this.getTestName());){
            DirectoryReader reader = searcher.getDirectoryReader();
            for (int i = 0; i < documents.size(); ++i) {
                Document document = reader.storedFields().document(i);
                LinkedHashSet<String> storedFieldNames = new LinkedHashSet<String>(document.getFields().stream().map(IndexableField::name).toList());
                NativeArrayIntegrationTestCase.assertThat(storedFieldNames, Matchers.contains((Object[])new String[]{"_id"}));
            }
            FieldInfo fieldInfo = FieldInfos.getMergedFieldInfos((IndexReader)reader).fieldInfo("object.field.offsets");
            NativeArrayIntegrationTestCase.assertThat(fieldInfo.getDocValuesType(), Matchers.equalTo((Object)DocValuesType.SORTED));
        }
    }
}

