/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.privilege;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.action.privilege.DeletePrivilegesRequestBuilder;
import org.elasticsearch.xpack.core.security.action.privilege.DeletePrivilegesResponse;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

@ServerlessScope(value=Scope.INTERNAL)
public class RestDeletePrivilegesAction
extends SecurityBaseRestHandler {
    public RestDeletePrivilegesAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.DELETE, "/_security/privilege/{application}/{privilege}"));
    }

    public String getName() {
        return "security_delete_privilege_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        final String application = request.param("application");
        final String[] privileges = request.paramAsStringArray("privilege", null);
        String refresh = request.param("refresh");
        return channel -> ((DeletePrivilegesRequestBuilder)new DeletePrivilegesRequestBuilder((ElasticsearchClient)client).application(application).privileges(privileges).setRefreshPolicy(refresh)).execute((ActionListener)new RestBuilderListener<DeletePrivilegesResponse>(this, channel){

            public RestResponse buildResponse(DeletePrivilegesResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                builder.startObject(application);
                for (String privilege : new HashSet<String>(Arrays.asList(privileges))) {
                    builder.field(privilege, Collections.singletonMap("found", response.found().contains(privilege)));
                }
                builder.endObject();
                builder.endObject();
                return new RestResponse(response.found().isEmpty() ? RestStatus.NOT_FOUND : RestStatus.OK, builder);
            }
        });
    }
}

