/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googleaistudio.completion;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.EmptyTaskSettings;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.googleaistudio.GoogleAiStudioModel;
import org.elasticsearch.xpack.inference.services.googleaistudio.completion.GoogleAiStudioCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public class GoogleAiStudioCompletionModel
extends GoogleAiStudioModel {
    public GoogleAiStudioCompletionModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, GoogleAiStudioCompletionServiceSettings.fromMap(serviceSettings, context), (TaskSettings)EmptyTaskSettings.INSTANCE, DefaultSecretSettings.fromMap(secrets));
    }

    GoogleAiStudioCompletionModel(String inferenceEntityId, TaskType taskType, String service, GoogleAiStudioCompletionServiceSettings serviceSettings, TaskSettings taskSettings, @Nullable DefaultSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, taskSettings), new ModelSecrets((SecretSettings)secrets), serviceSettings);
    }

    public URI uri(boolean streaming) {
        try {
            String api = streaming ? "streamGenerateContent" : "generateContent";
            return new URIBuilder().setScheme("https").setHost("generativelanguage.googleapis.com").setPathSegments(new String[]{"v1", "models", Strings.format((String)"%s:%s", (Object[])new Object[]{this.getServiceSettings().modelId(), api})}).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public GoogleAiStudioCompletionServiceSettings getServiceSettings() {
        return (GoogleAiStudioCompletionServiceSettings)super.getServiceSettings();
    }

    public DefaultSecretSettings getSecretSettings() {
        return (DefaultSecretSettings)super.getSecretSettings();
    }

    static URI buildUri(String model) throws URISyntaxException {
        return new URIBuilder().setScheme("https").setHost("generativelanguage.googleapis.com").setPathSegments(new String[]{"v1", "models", Strings.format((String)"%s:%s", (Object[])new Object[]{model, "generateContent"})}).build();
    }
}

