/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDenseVector;

public final class ToDenseVectorFromDoubleEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ToDenseVectorFromDoubleEvaluator.class);
    private final EvalOperator.ExpressionEvaluator d;

    public ToDenseVectorFromDoubleEvaluator(Source source, EvalOperator.ExpressionEvaluator d, DriverContext driverContext) {
        super(driverContext, source);
        this.d = d;
    }

    @Override
    public EvalOperator.ExpressionEvaluator next() {
        return this.d;
    }

    @Override
    public Block evalVector(Vector v) {
        DoubleVector vector = (DoubleVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            return this.driverContext.blockFactory().newConstantFloatBlockWith(this.evalValue(vector, 0), positionCount);
        }
        try (FloatBlock.Builder builder = this.driverContext.blockFactory().newFloatBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                builder.appendFloat(this.evalValue(vector, p));
            }
            FloatBlock floatBlock = builder.build();
            return floatBlock;
        }
    }

    private float evalValue(DoubleVector container, int index) {
        double value = container.getDouble(index);
        return ToDenseVector.fromDouble(value);
    }

    @Override
    public Block evalBlock(Block b) {
        DoubleBlock block = (DoubleBlock)b;
        int positionCount = block.getPositionCount();
        try (FloatBlock.Builder builder = this.driverContext.blockFactory().newFloatBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    float value = this.evalValue(block, i);
                    if (!positionOpened && valueCount > 1) {
                        builder.beginPositionEntry();
                        positionOpened = true;
                    }
                    builder.appendFloat(value);
                    valuesAppended = true;
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            FloatBlock floatBlock = builder.build();
            return floatBlock;
        }
    }

    private float evalValue(DoubleBlock container, int index) {
        double value = container.getDouble(index);
        return ToDenseVector.fromDouble(value);
    }

    public String toString() {
        return "ToDenseVectorFromDoubleEvaluator[d=" + String.valueOf(this.d) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.d);
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.d.baseRamBytesUsed();
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory d;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory d) {
            this.source = source;
            this.d = d;
        }

        public ToDenseVectorFromDoubleEvaluator get(DriverContext context) {
            return new ToDenseVectorFromDoubleEvaluator(this.source, this.d.get(context), context);
        }

        public String toString() {
            return "ToDenseVectorFromDoubleEvaluator[d=" + String.valueOf(this.d) + "]";
        }
    }
}

