/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.exponentialhistogram;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.exponentialhistogram.IndexWithCount;

final class EncodedHistogramData {
    static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(EncodedHistogramData.class);
    private static final int SCALE_OFFSET = 11;
    private static final int HAS_NEGATIVE_BUCKETS_FLAG = 64;
    private static final int SCALE_MASK = 63;
    private int scale;
    private byte[] encodedData;
    private int negativeBucketsStart;
    private int negativeBucketsLength;
    private int positiveBucketsLength;

    EncodedHistogramData() {
    }

    void decode(BytesRef data) throws IOException {
        this.encodedData = data.bytes;
        ByteArrayStreamInput input = new ByteArrayStreamInput();
        input.reset(data.bytes, data.offset, data.length);
        byte scaleWithFlags = input.readByte();
        this.scale = (scaleWithFlags & 0x3F) - 11;
        boolean hasNegativeBuckets = (scaleWithFlags & 0x40) != 0;
        this.negativeBucketsLength = 0;
        if (hasNegativeBuckets) {
            this.negativeBucketsLength = input.readVInt();
        }
        this.negativeBucketsStart = input.getPosition();
        input.skipBytes((long)this.negativeBucketsLength);
        this.positiveBucketsLength = input.available();
    }

    static void write(StreamOutput output, int scale, List<IndexWithCount> negativeBuckets, List<IndexWithCount> positiveBuckets) throws IOException {
        assert (scale >= -11 && scale <= 38) : "scale must be in range [-11, 38]";
        boolean hasNegativeBuckets = !negativeBuckets.isEmpty();
        int scaleWithFlags = scale + 11;
        assert (scaleWithFlags >= 0 && scaleWithFlags <= 63);
        if (hasNegativeBuckets) {
            scaleWithFlags |= 0x40;
        }
        output.writeByte((byte)scaleWithFlags);
        if (hasNegativeBuckets) {
            BytesStreamOutput temp = new BytesStreamOutput();
            BucketsDecoder.serializeBuckets((StreamOutput)temp, negativeBuckets);
            BytesReference data = temp.bytes();
            output.writeVInt(data.length());
            output.writeBytes(data.array(), data.arrayOffset(), data.length());
        }
        BucketsDecoder.serializeBuckets(output, positiveBuckets);
    }

    int scale() {
        return this.scale;
    }

    BucketsDecoder negativeBucketsDecoder() {
        return new BucketsDecoder(this.negativeBucketsStart, this.negativeBucketsLength);
    }

    BucketsDecoder positiveBucketsDecoder() {
        return new BucketsDecoder(this.negativeBucketsStart + this.negativeBucketsLength, this.positiveBucketsLength);
    }

    final class BucketsDecoder {
        private long currentIndex;
        private long currentCount;
        private final ByteArrayStreamInput bucketsStreamInput = new ByteArrayStreamInput();

        private BucketsDecoder(int encodedBucketsStartOffset, int length) {
            if (length > 0) {
                this.bucketsStreamInput.reset(EncodedHistogramData.this.encodedData, encodedBucketsStartOffset, length);
                try {
                    this.currentIndex = this.bucketsStreamInput.readZLong() - 1L;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Bad histogram bytes", e);
                }
                this.currentCount = 0L;
                this.advance();
            } else {
                this.markEndReached();
            }
        }

        private BucketsDecoder(BucketsDecoder toCopy) {
            this.bucketsStreamInput.reset(EncodedHistogramData.this.encodedData, toCopy.bucketsStreamInput.getPosition(), toCopy.bucketsStreamInput.getPosition());
            this.currentCount = toCopy.currentCount;
            this.currentIndex = toCopy.currentIndex;
        }

        BucketsDecoder copy() {
            return new BucketsDecoder(this);
        }

        private void markEndReached() {
            this.currentCount = -1L;
        }

        boolean hasNext() {
            return this.currentCount != -1L;
        }

        long peekCount() {
            assert (this.currentCount != -1L) : "End has already been reached";
            return this.currentCount;
        }

        long peekIndex() {
            assert (this.currentCount != -1L) : "End has already been reached";
            return this.currentIndex;
        }

        void advance() {
            assert (this.currentCount != -1L) : "End has already been reached";
            try {
                if (this.bucketsStreamInput.available() > 0) {
                    ++this.currentIndex;
                    long countOrNumEmptyBuckets = this.bucketsStreamInput.readZLong();
                    if (countOrNumEmptyBuckets < 0L) {
                        long numEmptyBuckets = -countOrNumEmptyBuckets;
                        this.currentIndex += numEmptyBuckets;
                        this.currentCount = this.bucketsStreamInput.readZLong();
                    } else {
                        this.currentCount = countOrNumEmptyBuckets;
                    }
                    assert (this.currentCount > 0L);
                } else {
                    this.markEndReached();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Bad histogram bytes", e);
            }
        }

        private static void serializeBuckets(StreamOutput out, List<IndexWithCount> buckets) throws IOException {
            if (buckets.isEmpty()) {
                return;
            }
            IndexWithCount firstBucket = buckets.getFirst();
            out.writeZLong(firstBucket.index());
            out.writeZLong(firstBucket.count());
            long prevIndex = firstBucket.index();
            for (int i = 1; i < buckets.size(); ++i) {
                IndexWithCount bucket = buckets.get(i);
                long indexDelta = bucket.index() - prevIndex;
                assert (indexDelta > 0L);
                assert (bucket.count() > 0L);
                long numEmptyBucketsInBetween = indexDelta - 1L;
                if (numEmptyBucketsInBetween > 0L) {
                    out.writeZLong(-numEmptyBucketsInBetween);
                }
                out.writeZLong(bucket.count());
                prevIndex = bucket.index();
            }
        }
    }
}

