/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectCommunicator;
import org.elasticsearch.xpack.ml.job.task.JobTask;

final class ProcessContext {
    private static final Logger LOGGER = LogManager.getLogger(ProcessContext.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final JobTask jobTask;
    private volatile AutodetectCommunicator autodetectCommunicator;
    private volatile ProcessState state;

    ProcessContext(JobTask jobTask) {
        this.jobTask = jobTask;
        this.state = new ProcessNotRunningState();
    }

    JobTask getJobTask() {
        return this.jobTask;
    }

    AutodetectCommunicator getAutodetectCommunicator() {
        return this.autodetectCommunicator;
    }

    private void setAutodetectCommunicator(AutodetectCommunicator autodetectCommunicator) {
        this.autodetectCommunicator = autodetectCommunicator;
    }

    ProcessStateName getState() {
        return this.state.getName();
    }

    private void setState(ProcessState state) {
        this.state = state;
    }

    void tryLock() {
        try {
            if (!this.lock.tryLock(MachineLearningField.STATE_PERSIST_RESTORE_TIMEOUT.getSeconds(), TimeUnit.SECONDS)) {
                LOGGER.error("Failed to acquire process lock for job [{}]", (Object)this.jobTask.getJobId());
                throw ExceptionsHelper.serverError((String)("Failed to acquire process lock for job [" + this.jobTask.getJobId() + "]"));
            }
        }
        catch (InterruptedException e) {
            throw new ElasticsearchStatusException(e.getMessage(), RestStatus.TOO_MANY_REQUESTS, (Throwable)e, new Object[0]);
        }
    }

    void unlock() {
        this.lock.unlock();
    }

    void setRunning(AutodetectCommunicator communicator) {
        assert (this.lock.isHeldByCurrentThread());
        this.state.setRunning(this, communicator);
    }

    boolean setDying() {
        assert (this.lock.isHeldByCurrentThread());
        return this.state.setDying(this);
    }

    KillBuilder newKillBuilder() {
        return new KillBuilder();
    }

    private static class ProcessNotRunningState
    implements ProcessState {
        private ProcessNotRunningState() {
        }

        @Override
        public boolean setRunning(ProcessContext processContext, AutodetectCommunicator autodetectCommunicator) {
            processContext.setAutodetectCommunicator(autodetectCommunicator);
            processContext.setState(new ProcessRunningState());
            return true;
        }

        @Override
        public boolean setDying(ProcessContext processContext) {
            processContext.setState(new ProcessDyingState());
            return true;
        }

        @Override
        public ProcessStateName getName() {
            return ProcessStateName.NOT_RUNNING;
        }
    }

    private static interface ProcessState {
        public boolean setRunning(ProcessContext var1, AutodetectCommunicator var2);

        public boolean setDying(ProcessContext var1);

        public ProcessStateName getName();
    }

    static enum ProcessStateName {
        NOT_RUNNING,
        RUNNING,
        DYING;

    }

    class KillBuilder {
        private boolean awaitCompletion;
        private boolean finish;
        private boolean silent;
        private boolean shouldFinalizeJob = true;
        private String reason;

        KillBuilder() {
        }

        KillBuilder setAwaitCompletion(boolean awaitCompletion) {
            this.awaitCompletion = awaitCompletion;
            return this;
        }

        KillBuilder setFinish(boolean finish) {
            this.finish = finish;
            return this;
        }

        KillBuilder setSilent(boolean silent) {
            this.silent = silent;
            return this;
        }

        KillBuilder setReason(String reason) {
            this.reason = reason;
            return this;
        }

        KillBuilder setShouldFinalizeJob(boolean shouldFinalizeJob) {
            this.shouldFinalizeJob = shouldFinalizeJob;
            return this;
        }

        void kill() {
            if (ProcessContext.this.autodetectCommunicator == null) {
                if (this.finish) {
                    ProcessContext.this.jobTask.markAsCompleted();
                }
                return;
            }
            String jobId = ProcessContext.this.jobTask.getJobId();
            if (!this.silent) {
                String extraInfo;
                String string = extraInfo = ProcessContext.this.state.getName() == ProcessStateName.DYING ? " while closing" : "";
                if (this.reason == null) {
                    LOGGER.info("Killing job [{}]{}", (Object)jobId, (Object)extraInfo);
                } else {
                    LOGGER.info("Killing job [{}]{}, because [{}]", (Object)jobId, (Object)extraInfo, (Object)this.reason);
                }
            }
            try {
                ProcessContext.this.autodetectCommunicator.killProcess(this.awaitCompletion, this.finish, this.shouldFinalizeJob);
            }
            catch (IOException e) {
                LOGGER.error("[{}] Failed to kill autodetect process for job", (Object)jobId);
            }
        }
    }

    private static class ProcessDyingState
    implements ProcessState {
        private ProcessDyingState() {
        }

        @Override
        public boolean setRunning(ProcessContext processContext, AutodetectCommunicator autodetectCommunicator) {
            LOGGER.debug("Process set to [running] while it was in [dying]");
            return false;
        }

        @Override
        public boolean setDying(ProcessContext processContext) {
            LOGGER.debug("Process set to [dying] while it was already in that state");
            return false;
        }

        @Override
        public ProcessStateName getName() {
            return ProcessStateName.DYING;
        }
    }

    private static class ProcessRunningState
    implements ProcessState {
        private ProcessRunningState() {
        }

        @Override
        public boolean setRunning(ProcessContext processContext, AutodetectCommunicator autodetectCommunicator) {
            LOGGER.debug("Process set to [running] while it was already in that state");
            return false;
        }

        @Override
        public boolean setDying(ProcessContext processContext) {
            processContext.setState(new ProcessDyingState());
            return true;
        }

        @Override
        public ProcessStateName getName() {
            return ProcessStateName.RUNNING;
        }
    }
}

