/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class SubGroup
implements ToXContentFragment {
    private final String name;
    private Long count;
    private final Map<String, SubGroup> subgroups;

    public static SubGroup root(String name) {
        return new SubGroup(name, null, new HashMap<String, SubGroup>());
    }

    public SubGroup(String name, Long count, Map<String, SubGroup> subgroups) {
        this.name = name;
        this.count = count;
        this.subgroups = subgroups;
    }

    public SubGroup addCount(String name, long count) {
        if (!this.subgroups.containsKey(name)) {
            this.subgroups.put(name, new SubGroup(name, count, new HashMap<String, SubGroup>()));
        } else {
            SubGroup s;
            SubGroup subGroup = s = this.subgroups.get(name);
            subGroup.count = subGroup.count + count;
        }
        return this;
    }

    public SubGroup getOrAddChild(String name) {
        if (!this.subgroups.containsKey(name)) {
            this.subgroups.put(name, new SubGroup(name, null, new HashMap<String, SubGroup>()));
        }
        return this.subgroups.get(name);
    }

    public Long getCount(String name) {
        SubGroup subGroup = this.subgroups.get(name);
        return subGroup != null ? subGroup.count : null;
    }

    public SubGroup getSubGroup(String name) {
        return this.subgroups.get(name);
    }

    public SubGroup copy() {
        HashMap<String, SubGroup> copy = new HashMap<String, SubGroup>(this.subgroups.size());
        for (Map.Entry<String, SubGroup> subGroup : this.subgroups.entrySet()) {
            copy.put(subGroup.getKey(), subGroup.getValue().copy());
        }
        return new SubGroup(this.name, this.count, copy);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        if (this.count != null) {
            builder.field("count", this.count);
        }
        if (this.subgroups != null && !this.subgroups.isEmpty()) {
            for (SubGroup subgroup : this.subgroups.values()) {
                subgroup.toXContent(builder, params);
            }
        }
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubGroup subGroup = (SubGroup)o;
        return Objects.equals(this.name, subGroup.name) && Objects.equals(this.count, subGroup.count) && Objects.equals(this.subgroups, subGroup.subgroups);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.count, this.subgroups);
    }

    public String toString() {
        return this.name;
    }

    public void merge(SubGroup s) {
        if (s == null) {
            return;
        }
        if (this.name.equals(s.name)) {
            if (this.count != null && s.count != null) {
                this.count = this.count + s.count;
            } else if (this.count == null) {
                this.count = s.count;
            }
            for (SubGroup subGroup : s.subgroups.values()) {
                if (this.subgroups.containsKey(subGroup.name)) {
                    this.subgroups.get(subGroup.name).merge(subGroup);
                    continue;
                }
                this.subgroups.put(subGroup.name, subGroup.copy());
            }
        }
    }
}

