/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.LinkedProjectConfig;
import org.elasticsearch.transport.ProxyConnectionStrategy;
import org.elasticsearch.transport.RemoteConnectionInfo;
import org.elasticsearch.transport.RemoteConnectionManager;
import org.elasticsearch.transport.SniffConnectionStrategy;
import org.elasticsearch.transport.TransportConnectionListener;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public abstract class RemoteConnectionStrategy
implements TransportConnectionListener,
Closeable {
    private final int maxPendingConnectionListeners;
    protected final Logger logger = LogManager.getLogger(this.getClass());
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Object mutex = new Object();
    private List<ActionListener<Void>> listeners = new ArrayList<ActionListener<Void>>();
    private final AtomicBoolean initialConnectionAttempted = new AtomicBoolean(false);
    protected final TransportService transportService;
    protected final RemoteConnectionManager connectionManager;
    protected final ProjectId originProjectId;
    protected final ProjectId linkedProjectId;
    protected final String clusterAlias;

    RemoteConnectionStrategy(LinkedProjectConfig config, TransportService transportService, RemoteConnectionManager connectionManager) {
        this.originProjectId = config.originProjectId();
        this.linkedProjectId = config.linkedProjectId();
        this.clusterAlias = config.linkedProjectAlias();
        this.transportService = transportService;
        this.connectionManager = connectionManager;
        this.maxPendingConnectionListeners = config.maxPendingConnectionListeners();
        connectionManager.addListener(this);
    }

    static ConnectionProfile buildConnectionProfile(LinkedProjectConfig config, boolean credentialsProtected) {
        String transportProfile = credentialsProtected ? "_remote_cluster" : "default";
        ConnectionProfile.Builder builder = new ConnectionProfile.Builder().setConnectTimeout(config.transportConnectTimeout()).setHandshakeTimeout(config.transportConnectTimeout()).setCompressionEnabled(config.connectionCompression()).setCompressionScheme(config.connectionCompressionScheme()).setPingInterval(config.clusterPingSchedule()).addConnections(0, TransportRequestOptions.Type.BULK, TransportRequestOptions.Type.STATE, TransportRequestOptions.Type.RECOVERY, TransportRequestOptions.Type.PING).addConnections(config.connectionStrategy().getNumberOfChannels(), TransportRequestOptions.Type.REG).setTransportProfile(transportProfile);
        return builder.build();
    }

    static InetSocketAddress parseConfiguredAddress(String configuredAddress) {
        InetAddress hostAddress;
        String host = RemoteConnectionStrategy.parseHost(configuredAddress);
        int port = RemoteConnectionStrategy.parsePort(configuredAddress);
        try {
            hostAddress = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("unknown host [" + host + "]", e);
        }
        return new InetSocketAddress(hostAddress, port);
    }

    static String parseHost(String configuredAddress) {
        return configuredAddress.substring(0, RemoteConnectionStrategy.indexOfPortSeparator(configuredAddress));
    }

    static int parsePort(String remoteHost) {
        try {
            int port = Integer.parseInt(remoteHost.substring(RemoteConnectionStrategy.indexOfPortSeparator(remoteHost) + 1));
            if (port <= 0) {
                throw new IllegalArgumentException("port number must be > 0 but was: [" + port + "]");
            }
            return port;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("failed to parse port", e);
        }
    }

    private static int indexOfPortSeparator(String remoteHost) {
        int portSeparator = remoteHost.lastIndexOf(58);
        if (portSeparator == -1 || portSeparator == remoteHost.length()) {
            throw new IllegalArgumentException("remote hosts need to be configured as [host:port], found [" + remoteHost + "] instead");
        }
        return portSeparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect(ActionListener<Void> connectListener) {
        boolean isCurrentlyClosed;
        boolean runConnect = false;
        ContextPreservingActionListener<Void> listener = ContextPreservingActionListener.wrapPreservingContext(connectListener, this.transportService.getThreadPool().getThreadContext());
        Object object = this.mutex;
        synchronized (object) {
            isCurrentlyClosed = this.closed.get();
            if (isCurrentlyClosed) {
                assert (this.listeners.isEmpty());
            } else {
                if (this.listeners.size() >= this.maxPendingConnectionListeners) {
                    assert (this.listeners.size() == this.maxPendingConnectionListeners);
                    listener.onFailure(new EsRejectedExecutionException("connect listener queue is full"));
                    return;
                }
                this.listeners.add(listener);
                runConnect = this.listeners.size() == 1;
            }
        }
        if (isCurrentlyClosed) {
            connectListener.onFailure((Exception)((Object)new AlreadyClosedException("connect handler is already closed")));
            return;
        }
        if (runConnect) {
            ExecutorService executor = this.transportService.getThreadPool().executor("management");
            executor.submit(new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    ActionListener.onFailure(RemoteConnectionStrategy.this.getAndClearListeners(), e);
                }

                @Override
                protected void doRun() {
                    RemoteConnectionStrategy.this.connectImpl(new ActionListener<Void>(){

                        @Override
                        public void onResponse(Void aVoid) {
                            RemoteConnectionStrategy.this.connectionAttemptCompleted(null);
                            ActionListener.onResponse(RemoteConnectionStrategy.this.getAndClearListeners(), aVoid);
                        }

                        @Override
                        public void onFailure(Exception e) {
                            RemoteConnectionStrategy.this.connectionAttemptCompleted(e);
                            ActionListener.onFailure(RemoteConnectionStrategy.this.getAndClearListeners(), e);
                        }
                    });
                }
            });
        }
    }

    private void connectionAttemptCompleted(@Nullable Exception e) {
        boolean isInitialAttempt = this.initialConnectionAttempted.compareAndSet(false, true);
        Supplier msgSupplier = () -> Strings.format((String)"Origin project [%s] %s linked project [%s] with alias [%s] on %s attempt", (Object[])new Object[]{this.originProjectId, e == null ? "successfully connected to" : "failed to connect to", this.linkedProjectId, this.clusterAlias, isInitialAttempt ? "the initial connection" : "a reconnection"});
        if (e == null) {
            this.logger.debug(msgSupplier);
        } else {
            this.logger.warn(msgSupplier, (Throwable)e);
        }
    }

    boolean shouldRebuildConnection(LinkedProjectConfig config) {
        return !config.connectionStrategy().equals((Object)this.strategyType()) || this.connectionProfileChanged(config) || this.strategyMustBeRebuilt(config);
    }

    protected abstract boolean strategyMustBeRebuilt(LinkedProjectConfig var1);

    protected abstract ConnectionStrategy strategyType();

    @Override
    public void onNodeDisconnected(DiscoveryNode node, @Nullable Exception closeException) {
        if (this.shouldOpenMoreConnections()) {
            this.connect(ActionListener.wrap(ignore -> this.logger.trace("[{}] successfully connected after disconnect of {}", (Object)this.clusterAlias, (Object)node), e -> this.logger.debug(() -> Strings.format((String)"[%s] failed to connect after disconnect of %s", (Object[])new Object[]{this.clusterAlias, node}), (Throwable)e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        List<ActionListener<Object>> toNotify;
        Object object = this.mutex;
        synchronized (object) {
            if (this.closed.compareAndSet(false, true)) {
                this.connectionManager.removeListener(this);
                toNotify = this.listeners;
                this.listeners = Collections.emptyList();
            } else {
                toNotify = Collections.emptyList();
            }
        }
        ActionListener.onFailure(toNotify, (Exception)((Object)new AlreadyClosedException("connect handler is already closed")));
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean assertNoRunningConnections() {
        Object object = this.mutex;
        synchronized (object) {
            assert (this.listeners.isEmpty());
        }
        return true;
    }

    protected abstract boolean shouldOpenMoreConnections();

    protected abstract void connectImpl(ActionListener<Void> var1);

    protected abstract RemoteConnectionInfo.ModeInfo getModeInfo();

    protected static boolean isRetryableException(Exception e) {
        return e instanceof ConnectTransportException || e instanceof IOException || e instanceof IllegalStateException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ActionListener<Void>> getAndClearListeners() {
        List<ActionListener<Void>> result;
        Object object = this.mutex;
        synchronized (object) {
            if (this.listeners.isEmpty()) {
                result = Collections.emptyList();
            } else {
                result = this.listeners;
                this.listeners = new ArrayList<ActionListener<Void>>();
            }
        }
        return result;
    }

    private boolean connectionProfileChanged(LinkedProjectConfig config) {
        ConnectionProfile oldProfile = this.connectionManager.getConnectionProfile();
        ConnectionProfile newProfile = new ConnectionProfile.Builder(oldProfile).setCompressionEnabled(config.connectionCompression()).setCompressionScheme(config.connectionCompressionScheme()).setPingInterval(config.clusterPingSchedule()).build();
        return !Objects.equals((Object)oldProfile.getCompressionEnabled(), (Object)newProfile.getCompressionEnabled()) || !Objects.equals(oldProfile.getPingInterval(), newProfile.getPingInterval()) || !Objects.equals((Object)oldProfile.getCompressionScheme(), (Object)newProfile.getCompressionScheme());
    }

    static enum ConnectionStrategy {
        SNIFF(6, SniffConnectionStrategy::infoReader){

            public String toString() {
                return "sniff";
            }
        }
        ,
        PROXY(1, ProxyConnectionStrategy::infoReader){

            public String toString() {
                return "proxy";
            }
        };

        private final int numberOfChannels;
        private final java.util.function.Supplier<Writeable.Reader<RemoteConnectionInfo.ModeInfo>> reader;

        private ConnectionStrategy(int numberOfChannels, java.util.function.Supplier<Writeable.Reader<RemoteConnectionInfo.ModeInfo>> reader) {
            this.numberOfChannels = numberOfChannels;
            this.reader = reader;
        }

        public int getNumberOfChannels() {
            return this.numberOfChannels;
        }

        public Writeable.Reader<RemoteConnectionInfo.ModeInfo> getReader() {
            return this.reader.get();
        }
    }
}

