/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.authentication;

import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.authentication.AllowedHostsValidator;
import com.microsoft.kiota.authentication.ApiKeyLocation;
import com.microsoft.kiota.authentication.AuthenticationProvider;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;

public class ApiKeyAuthenticationProvider
implements AuthenticationProvider {
    private final ApiKeyLocation location;
    @Nonnull
    private final String paramName;
    @Nonnull
    private final String apiKey;
    private final AllowedHostsValidator validator;
    private static final String parentSpanKey = "parent-span";

    public ApiKeyAuthenticationProvider(@Nonnull String apiKey, @Nonnull String paramName, @Nonnull ApiKeyLocation location, String ... validHosts) {
        Objects.requireNonNull(apiKey);
        Objects.requireNonNull(paramName);
        Objects.requireNonNull(location);
        if (apiKey.isEmpty()) {
            throw new IllegalArgumentException("apiKey cannot be empty");
        }
        if (paramName.isEmpty()) {
            throw new IllegalArgumentException("paramName cannot be empty");
        }
        this.apiKey = apiKey;
        this.paramName = paramName;
        this.location = location;
        this.validator = new AllowedHostsValidator(validHosts);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void authenticateRequest(@Nonnull RequestInformation request, @Nullable Map<String, Object> additionalAuthenticationContext) {
        Span span;
        Objects.requireNonNull(request);
        if (additionalAuthenticationContext != null && additionalAuthenticationContext.containsKey(parentSpanKey) && additionalAuthenticationContext.get(parentSpanKey) instanceof Span) {
            Span parentSpan = (Span)additionalAuthenticationContext.get(parentSpanKey);
            span = GlobalOpenTelemetry.getTracer((String)"com.microsoft.kiota").spanBuilder("authenticateRequest").setParent(Context.current().with((ImplicitContextKeyed)parentSpan)).startSpan();
        } else {
            span = GlobalOpenTelemetry.getTracer((String)"com.microsoft.kiota").spanBuilder("authenticateRequest").startSpan();
        }
        try (Scope scope = span.makeCurrent();){
            URI uri = request.getUri();
            if (uri == null || !this.validator.isUrlHostValid(uri)) {
                span.setAttribute("com.microsoft.kiota.authentication.is_url_valid", false);
                return;
            }
            if (!uri.getScheme().equalsIgnoreCase("https")) {
                span.setAttribute("com.microsoft.kiota.authentication.is_url_valid", false);
                throw new IllegalArgumentException("Only https is supported");
            }
            span.setAttribute("com.microsoft.kiota.authentication.is_url_valid", true);
            switch (this.location) {
                case HEADER: {
                    request.headers.add(this.paramName, this.apiKey);
                    return;
                }
                case QUERY_PARAMETER: {
                    request.setUri(new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), uri.getQuery() == null ? this.paramName + "=" + this.apiKey : uri.getQuery() + "&" + this.paramName + "=" + this.apiKey, uri.getFragment()));
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported key location");
                }
            }
        }
        catch (URISyntaxException e) {
            span.recordException((Throwable)e);
            throw new RuntimeException("Malformed URI", e);
        }
        catch (IllegalArgumentException e) {
            span.recordException((Throwable)e);
            throw e;
        }
        finally {
            span.end();
        }
    }
}

