"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var response_exports = {};
__export(response_exports, {
  Response: () => Response,
  parseResponse: () => parseResponse,
  requestDebug: () => requestDebug
});
module.exports = __toCommonJS(response_exports);
var import_utilsBundle = require("playwright-core/lib/utilsBundle");
var import_tab = require("./tab");
const requestDebug = (0, import_utilsBundle.debug)("pw:mcp:request");
class Response {
  constructor(context, toolName, toolArgs) {
    this._result = [];
    this._code = [];
    this._images = [];
    this._includeSnapshot = false;
    this._includeTabs = false;
    this._context = context;
    this.toolName = toolName;
    this.toolArgs = toolArgs;
  }
  addResult(result) {
    this._result.push(result);
  }
  addError(error) {
    this._result.push(error);
    this._isError = true;
  }
  isError() {
    return this._isError;
  }
  result() {
    return this._result.join("\n");
  }
  addCode(code) {
    this._code.push(code);
  }
  code() {
    return this._code.join("\n");
  }
  addImage(image) {
    this._images.push(image);
  }
  images() {
    return this._images;
  }
  setIncludeSnapshot() {
    this._includeSnapshot = true;
  }
  setIncludeTabs() {
    this._includeTabs = true;
  }
  async finish() {
    if (this._includeSnapshot && this._context.currentTab())
      this._tabSnapshot = await this._context.currentTabOrDie().captureSnapshot();
    for (const tab of this._context.tabs())
      await tab.updateTitle();
  }
  tabSnapshot() {
    return this._tabSnapshot;
  }
  logBegin() {
    if (requestDebug.enabled)
      requestDebug(this.toolName, this.toolArgs);
  }
  logEnd() {
    if (requestDebug.enabled)
      requestDebug(this.serialize({ omitSnapshot: true, omitBlobs: true }));
  }
  serialize(options = {}) {
    const response = [];
    if (this._result.length) {
      response.push("### Result");
      response.push(this._result.join("\n"));
      response.push("");
    }
    if (this._code.length) {
      response.push(`### Ran Playwright code
\`\`\`js
${this._code.join("\n")}
\`\`\``);
      response.push("");
    }
    if (this._includeSnapshot || this._includeTabs)
      response.push(...renderTabsMarkdown(this._context.tabs(), this._includeTabs));
    if (this._tabSnapshot?.modalStates.length) {
      response.push(...(0, import_tab.renderModalStates)(this._context, this._tabSnapshot.modalStates));
      response.push("");
    } else if (this._tabSnapshot) {
      response.push(renderTabSnapshot(this._tabSnapshot, options));
      response.push("");
    }
    const content = [
      { type: "text", text: response.join("\n") }
    ];
    if (this._context.config.imageResponses !== "omit") {
      for (const image of this._images)
        content.push({ type: "image", data: options.omitBlobs ? "<blob>" : image.data.toString("base64"), mimeType: image.contentType });
    }
    this._redactSecrets(content);
    return { content, isError: this._isError };
  }
  _redactSecrets(content) {
    if (!this._context.config.secrets)
      return;
    for (const item of content) {
      if (item.type !== "text")
        continue;
      for (const [secretName, secretValue] of Object.entries(this._context.config.secrets))
        item.text = item.text.replaceAll(secretValue, `<secret>${secretName}</secret>`);
    }
  }
}
function renderTabSnapshot(tabSnapshot, options = {}) {
  const lines = [];
  if (tabSnapshot.consoleMessages.length) {
    lines.push(`### New console messages`);
    for (const message of tabSnapshot.consoleMessages)
      lines.push(`- ${trim(message.toString(), 100)}`);
    lines.push("");
  }
  if (tabSnapshot.downloads.length) {
    lines.push(`### Downloads`);
    for (const entry of tabSnapshot.downloads) {
      if (entry.finished)
        lines.push(`- Downloaded file ${entry.download.suggestedFilename()} to ${entry.outputFile}`);
      else
        lines.push(`- Downloading file ${entry.download.suggestedFilename()} ...`);
    }
    lines.push("");
  }
  lines.push(`### Page state`);
  lines.push(`- Page URL: ${tabSnapshot.url}`);
  lines.push(`- Page Title: ${tabSnapshot.title}`);
  lines.push(`- Page Snapshot:`);
  lines.push("```yaml");
  lines.push(options.omitSnapshot ? "<snapshot>" : tabSnapshot.ariaSnapshot);
  lines.push("```");
  return lines.join("\n");
}
function renderTabsMarkdown(tabs, force = false) {
  if (tabs.length === 1 && !force)
    return [];
  if (!tabs.length) {
    return [
      "### Open tabs",
      'No open tabs. Use the "browser_navigate" tool to navigate to a page first.',
      ""
    ];
  }
  const lines = ["### Open tabs"];
  for (let i = 0; i < tabs.length; i++) {
    const tab = tabs[i];
    const current = tab.isCurrentTab() ? " (current)" : "";
    lines.push(`- ${i}:${current} [${tab.lastTitle()}] (${tab.page.url()})`);
  }
  lines.push("");
  return lines;
}
function trim(text, maxLength) {
  if (text.length <= maxLength)
    return text;
  return text.slice(0, maxLength) + "...";
}
function parseSections(text) {
  const sections = /* @__PURE__ */ new Map();
  const sectionHeaders = text.split(/^### /m).slice(1);
  for (const section of sectionHeaders) {
    const firstNewlineIndex = section.indexOf("\n");
    if (firstNewlineIndex === -1)
      continue;
    const sectionName = section.substring(0, firstNewlineIndex);
    const sectionContent = section.substring(firstNewlineIndex + 1).trim();
    sections.set(sectionName, sectionContent);
  }
  return sections;
}
function parseResponse(response) {
  if (response.content?.[0].type !== "text")
    return void 0;
  const text = response.content[0].text;
  const sections = parseSections(text);
  const result = sections.get("Result");
  const code = sections.get("Ran Playwright code");
  const tabs = sections.get("Open tabs");
  const pageState = sections.get("Page state");
  const consoleMessages = sections.get("New console messages");
  const modalState = sections.get("Modal state");
  const downloads = sections.get("Downloads");
  const codeNoFrame = code?.replace(/^```js\n/, "").replace(/\n```$/, "");
  const isError = response.isError;
  const attachments = response.content.slice(1);
  return {
    result,
    code: codeNoFrame,
    tabs,
    pageState,
    consoleMessages,
    modalState,
    downloads,
    isError,
    attachments
  };
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Response,
  parseResponse,
  requestDebug
});
