/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.metrics;

import java.math.BigDecimal;
import org.logstash.instrument.metrics.AbstractMetric;
import org.logstash.instrument.metrics.Metric;
import org.logstash.instrument.metrics.MetricType;

public class UpScaledMetric
extends AbstractMetric<BigDecimal>
implements Metric<BigDecimal> {
    private final Metric<? extends Number> metric;
    private final BigDecimal scaleFactor;

    public UpScaledMetric(String name, Metric<? extends Number> metric, int scaleFactor) {
        super(name);
        this.metric = metric;
        this.scaleFactor = BigDecimal.valueOf(scaleFactor);
    }

    public UpScaledMetric(Metric<? extends Number> metric, int scaleFactor) {
        this(String.format("%s_x%s", metric.getName(), scaleFactor), metric, scaleFactor);
    }

    @Override
    public MetricType getType() {
        return MetricType.GAUGE_NUMBER;
    }

    @Override
    public BigDecimal getValue() {
        Number unscaledValue = this.metric.getValue();
        BigDecimal scaledValue = UpScaledMetric.convertToBigDecimal(unscaledValue).multiply(this.scaleFactor);
        return scaledValue;
    }

    private static BigDecimal convertToBigDecimal(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Integer || number instanceof Long || number instanceof Short || number instanceof Byte) {
            return BigDecimal.valueOf(number.longValue());
        }
        return BigDecimal.valueOf(number.doubleValue());
    }
}

