/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.functions.StringFn;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleNodeConstructor
extends Instruction {
    protected Expression select = Literal.makeEmptySequence(this.getContainer());

    public void setSelect(Expression select, Configuration config) {
        this.select = select;
        this.adoptChildExpression(select);
    }

    public Expression getContentExpression() {
        return this.select;
    }

    @Override
    public final boolean createsNewNodes() {
        return true;
    }

    @Override
    public int computeCardinality() {
        return this.select.getCardinality();
    }

    @Override
    public int computeSpecialProperties() {
        return super.computeSpecialProperties() | 0x800000;
    }

    public abstract void localTypeCheck(ExpressionVisitor var1, ContextItemStaticInfo var2) throws XPathException;

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression arg;
        Expression valSelect;
        this.localTypeCheck(visitor, contextInfo);
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.select = visitor.typeCheck(this.select, contextInfo);
        if (this.select instanceof ValueOf && th.isSubType((valSelect = ((ValueOf)this.select).getContentExpression()).getItemType(), BuiltInAtomicType.STRING) && !Cardinality.allowsMany(valSelect.getCardinality())) {
            this.select = valSelect;
        }
        if (this.select instanceof StringFn) {
            StringFn fn = (StringFn)this.select;
            Expression arg2 = fn.getArguments()[0];
            if (arg2.getItemType() == BuiltInAtomicType.UNTYPED_ATOMIC && !Cardinality.allowsMany(arg2.getCardinality())) {
                this.select = arg2;
            }
        } else if (this.select instanceof CastExpression && ((CastExpression)this.select).getTargetType() == BuiltInAtomicType.STRING && (arg = ((CastExpression)this.select).getBaseExpression()).getItemType() == BuiltInAtomicType.UNTYPED_ATOMIC && !Cardinality.allowsMany(arg.getCardinality())) {
            this.select = arg;
        }
        this.adoptChildExpression(this.select);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        this.select = visitor.optimize(this.select, contextItemType);
        if (this.select instanceof StringFn) {
            StringFn sf = (StringFn)this.select;
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            if (th.isSubType(sf.getArguments()[0].getItemType(), BuiltInAtomicType.STRING) && !Cardinality.allowsMany(sf.getArguments()[0].getCardinality())) {
                this.select = sf.getArguments()[0];
            }
        }
        this.adoptChildExpression(this.select);
        return this;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(new Operand(this.select, OperandRole.SINGLE_ATOMIC));
    }

    @Override
    public boolean replaceOperand(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        CharSequence value;
        if (this.getHostLanguage() == 50 && !this.getContainer().getPackageData().isAllowXPath30()) {
            int savedOutputState = context.getTemporaryOutputState();
            context.setTemporaryOutputState(this.getInstructionNameCode());
            value = this.select.evaluateAsString(context);
            context.setTemporaryOutputState(savedOutputState);
        } else {
            value = this.select.evaluateAsString(context);
        }
        try {
            this.processValue(value, context);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            throw e;
        }
        return null;
    }

    public abstract void processValue(CharSequence var1, XPathContext var2) throws XPathException;

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        String content;
        Item contentItem;
        if (this.getHostLanguage() == 50 && !this.getContainer().getPackageData().isAllowXPath30()) {
            int savedOutputState = context.getTemporaryOutputState();
            context.setTemporaryOutputState(this.getInstructionNameCode());
            contentItem = this.select.evaluateItem(context);
            context.setTemporaryOutputState(savedOutputState);
        } else {
            contentItem = this.select.evaluateItem(context);
        }
        if (contentItem == null) {
            content = "";
        } else {
            content = contentItem.getStringValue();
            content = this.checkContent(content, context);
        }
        Orphan o = new Orphan(context.getConfiguration());
        o.setNodeKind((short)this.getItemType().getPrimitiveType());
        o.setStringValue(content);
        o.setNodeName(this.evaluateNodeName(context));
        return o;
    }

    protected String checkContent(String data, XPathContext context) throws XPathException {
        return data;
    }

    public NodeName evaluateNodeName(XPathContext context) throws XPathException {
        return null;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return SingletonIterator.makeIterator(this.evaluateItem(context));
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.select = this.doPromotion(this.select, offer);
        super.promoteInst(offer);
    }
}

