/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.net.URL;
import org.jruby.util.Loader;

public class UriLikePathHelper {
    private final Loader loader;

    public UriLikePathHelper(Loader loader) {
        this.loader = loader;
    }

    public URL getResource(String ref) {
        URL url = this.get(ref);
        if (url == null && ref.startsWith("/")) {
            url = this.get(ref.substring(1));
        }
        return url;
    }

    private URL get(String ref) {
        return this.loader.getResource(ref);
    }

    public String getUriLikePath() {
        return this.createUri("/.jrubydir");
    }

    public String getUriLikeGemPath() {
        return this.createUri("/specifications/.jrubydir");
    }

    private String createUri(String ref) {
        URL url = this.getResource(ref);
        if (url == null) {
            return null;
        }
        return "uri:" + url.toString().replaceFirst(ref + "$", "");
    }
}

