/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.io.Serializable;
import org.apache.derby.iapi.services.compiler.ClassBuilder;
import org.apache.derby.iapi.services.compiler.JavaFactory;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.ExpressionClassBuilderInterface;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.sql.compile.OrderedColumnList;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.execute.IndexColumnOrder;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

abstract class ExpressionClassBuilder
implements ExpressionClassBuilderInterface {
    protected static final String currentDatetimeFieldName = "cdt";
    protected ClassBuilder cb;
    protected GeneratedClass gc;
    protected int nextExprNum;
    protected int nextNonFastExpr;
    protected int nextFieldNum;
    protected MethodBuilder constructor;
    CompilerContext myCompCtx;
    MethodBuilder executeMethod;
    protected LocalField cdtField;
    private String currentRowScanResultSetName;
    private Object getDVF;
    private Object getRSF;
    private Object getEF;

    ExpressionClassBuilder(String superClass, String className, CompilerContext cc) throws StandardException {
        int modifiers = 17;
        this.myCompCtx = cc;
        JavaFactory javaFac = this.myCompCtx.getJavaFactory();
        if (className == null) {
            className = this.myCompCtx.getUniqueClassName();
        }
        this.cb = javaFac.newClassBuilder(this.myCompCtx.getClassFactory(), this.getPackageName(), modifiers, className, superClass);
        this.beginConstructor();
    }

    abstract String getPackageName();

    abstract int getRowCount() throws StandardException;

    abstract void setNumSubqueries() throws StandardException;

    abstract String getBaseClassName();

    MethodBuilder getConstructor() {
        return this.constructor;
    }

    ClassBuilder getClassBuilder() {
        return this.cb;
    }

    MethodBuilder getExecuteMethod() {
        if (this.executeMethod == null) {
            this.executeMethod = this.cb.newMethodBuilder(4, "void", "reinit");
            this.executeMethod.addThrownException("org.apache.derby.shared.common.error.StandardException");
        }
        return this.executeMethod;
    }

    private void beginConstructor() {
        MethodBuilder realConstructor = this.cb.newConstructorBuilder(1);
        realConstructor.callSuper();
        realConstructor.methodReturn();
        realConstructor.complete();
        this.constructor = this.cb.newMethodBuilder(1, "void", "postConstructor");
        this.constructor.addThrownException("org.apache.derby.shared.common.error.StandardException");
    }

    void finishConstructor() throws StandardException {
        this.setNumSubqueries();
        int numResultSets = this.getRowCount();
        if (numResultSets >= 1) {
            this.addNewArrayOfRows(numResultSets);
        }
        this.constructor.methodReturn();
        this.constructor.complete();
    }

    private void addNewArrayOfRows(int numResultSets) {
        this.constructor.pushThis();
        this.constructor.pushNewArray("org.apache.derby.iapi.sql.execute.ExecRow", numResultSets);
        this.constructor.putField("org.apache.derby.impl.sql.execute.BaseActivation", "row", "org.apache.derby.iapi.sql.execute.ExecRow[]");
        this.constructor.endStatement();
    }

    LocalField newFieldDeclaration(int modifiers, String type, String name) {
        return this.cb.addField(type, name, modifiers);
    }

    LocalField newFieldDeclaration(int modifiers, String type) {
        return this.cb.addField(type, this.newFieldName(), modifiers);
    }

    MethodBuilder newGeneratedFun(String returnType, int modifiers) {
        return this.newGeneratedFun(returnType, modifiers, null);
    }

    MethodBuilder newGeneratedFun(String returnType, int modifiers, String[] params) {
        String exprName = "g".concat(Integer.toString(this.nextNonFastExpr++));
        return this.newGeneratedFun(exprName, returnType, modifiers, params);
    }

    private MethodBuilder newGeneratedFun(String exprName, String returnType, int modifiers, String[] params) {
        MethodBuilder exprMethod = params == null ? this.cb.newMethodBuilder(modifiers, returnType, exprName) : this.cb.newMethodBuilder(modifiers, returnType, exprName, params);
        exprMethod.addThrownException("org.apache.derby.shared.common.error.StandardException");
        return exprMethod;
    }

    MethodBuilder newExprFun() {
        String exprName = "e".concat(Integer.toString(this.nextExprNum++));
        return this.newGeneratedFun(exprName, "java.lang.Object", 1, null);
    }

    void pushMethodReference(MethodBuilder mb, MethodBuilder exprMethod) {
        mb.pushThis();
        mb.push(exprMethod.getName());
        mb.callMethod((short)185, "org.apache.derby.iapi.services.loader.GeneratedByteCode", "getMethod", "org.apache.derby.iapi.services.loader.GeneratedMethod", 1);
    }

    MethodBuilder newUserExprFun() {
        MethodBuilder mb = this.newExprFun();
        mb.addThrownException("java.lang.Exception");
        return mb;
    }

    void getCurrentDateExpression(MethodBuilder mb) {
        LocalField lf = this.getCurrentSetup();
        mb.getField(lf);
        mb.callMethod((short)182, null, "getCurrentDate", "java.sql.Date", 0);
    }

    void getCurrentTimeExpression(MethodBuilder mb) {
        LocalField lf = this.getCurrentSetup();
        mb.getField(lf);
        mb.callMethod((short)182, null, "getCurrentTime", "java.sql.Time", 0);
    }

    void getCurrentTimestampExpression(MethodBuilder mb) {
        LocalField lf = this.getCurrentSetup();
        mb.getField(lf);
        mb.callMethod((short)182, null, "getCurrentTimestamp", "java.sql.Timestamp", 0);
    }

    FormatableArrayHolder getColumnOrdering(ResultColumnList rclist) {
        int i;
        int numCols = rclist == null ? 0 : rclist.size();
        int numRealCols = 0;
        for (i = 0; i < numCols; ++i) {
            if (rclist.getResultColumn(i + 1).isGeneratedForUnmatchedColumnInInsert()) continue;
            ++numRealCols;
        }
        Object[] ordering = new IndexColumnOrder[numRealCols];
        int j = 0;
        for (i = 0; i < numCols; ++i) {
            if (rclist.getResultColumn(i + 1).isGeneratedForUnmatchedColumnInInsert()) continue;
            ordering[j] = new IndexColumnOrder(i);
            ++j;
        }
        return new FormatableArrayHolder(ordering);
    }

    FormatableArrayHolder addColumnToOrdering(FormatableArrayHolder orderingHolder, int columnNum) {
        ColumnOrdering[] ordering = (ColumnOrdering[])orderingHolder.getArray(ColumnOrdering[].class);
        int length = ordering.length;
        for (int i = 0; i < length; ++i) {
            if (ordering[i].getColumnId() != columnNum) continue;
            return orderingHolder;
        }
        Object[] newOrdering = new IndexColumnOrder[length + 1];
        System.arraycopy(ordering, 0, newOrdering, 0, length);
        newOrdering[length] = new IndexColumnOrder(columnNum);
        return new FormatableArrayHolder(newOrdering);
    }

    FormatableArrayHolder getColumnOrdering(OrderedColumnList<?> oclist) {
        int numCols;
        int n = numCols = oclist == null ? 0 : oclist.size();
        if (numCols == 0) {
            return new FormatableArrayHolder(new IndexColumnOrder[0]);
        }
        return new FormatableArrayHolder(oclist.getColumnOrdering());
    }

    int addItem(Object o) {
        if (o != null && !(o instanceof Serializable)) {
            SanityManager.THROWASSERT((String)("o (" + o.getClass().getName() + ") expected to be instanceof java.io.Serializable"));
        }
        return this.myCompCtx.addSavedObject(o);
    }

    void pushDataValueFactory(MethodBuilder mb) {
        if (this.getDVF == null) {
            this.getDVF = mb.describeMethod((short)182, this.getBaseClassName(), "getDataValueFactory", "org.apache.derby.iapi.types.DataValueFactory");
        }
        mb.pushThis();
        mb.callMethod(this.getDVF);
    }

    void pushGetResultSetFactoryExpression(MethodBuilder mb) {
        if (this.getRSF == null) {
            this.getRSF = mb.describeMethod((short)182, this.getBaseClassName(), "getResultSetFactory", "org.apache.derby.iapi.sql.execute.ResultSetFactory");
        }
        mb.pushThis();
        mb.callMethod(this.getRSF);
    }

    void pushGetExecutionFactoryExpression(MethodBuilder mb) {
        if (this.getEF == null) {
            this.getEF = mb.describeMethod((short)182, this.getBaseClassName(), "getExecutionFactory", "org.apache.derby.iapi.sql.execute.ExecutionFactory");
        }
        mb.pushThis();
        mb.callMethod(this.getEF);
    }

    void pushColumnReference(MethodBuilder mb, int rsNumber, int colId) {
        mb.pushThis();
        mb.push(rsNumber);
        mb.push(colId);
        mb.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "getColumnFromRow", "org.apache.derby.iapi.types.DataValueDescriptor", 2);
    }

    void pushPVSReference(MethodBuilder mb) {
        mb.pushThis();
        mb.getField("org.apache.derby.impl.sql.execute.BaseActivation", "pvs", "org.apache.derby.iapi.sql.ParameterValueSet");
    }

    protected LocalField getCurrentSetup() {
        if (this.cdtField != null) {
            return this.cdtField;
        }
        this.cdtField = this.newFieldDeclaration(2, "org.apache.derby.impl.sql.execute.CurrentDatetime", currentDatetimeFieldName);
        this.constructor.pushNewStart("org.apache.derby.impl.sql.execute.CurrentDatetime");
        this.constructor.pushNewComplete(0);
        this.constructor.setField(this.cdtField);
        return this.cdtField;
    }

    private String newFieldName() {
        return "e".concat(Integer.toString(this.nextFieldNum++));
    }

    protected TypeCompiler getTypeCompiler(TypeId typeId) {
        return this.myCompCtx.getTypeCompilerFactory().getTypeCompiler(typeId);
    }

    GeneratedClass getGeneratedClass(ByteArray savedBytes) throws StandardException {
        if (this.gc != null) {
            return this.gc;
        }
        if (savedBytes != null) {
            ByteArray classBytecode = this.cb.getClassBytecode();
            savedBytes.setBytes(classBytecode.getArray());
            savedBytes.setLength(classBytecode.getLength());
        }
        this.gc = this.cb.getGeneratedClass();
        return this.gc;
    }

    void pushThisAsActivation(MethodBuilder mb) {
        mb.pushThis();
        mb.upCast("org.apache.derby.iapi.sql.Activation");
    }

    void generateNull(MethodBuilder mb, TypeCompiler tc, int collationType) {
        this.pushDataValueFactory(mb);
        mb.pushNull(tc.interfaceName());
        tc.generateNull(mb, collationType);
    }

    void generateNullWithExpress(MethodBuilder mb, TypeCompiler tc, int collationType) {
        this.pushDataValueFactory(mb);
        mb.swap();
        mb.cast(tc.interfaceName());
        tc.generateNull(mb, collationType);
    }

    void generateDataValue(MethodBuilder mb, TypeCompiler tc, int collationType, LocalField field) {
        this.pushDataValueFactory(mb);
        mb.swap();
        tc.generateDataValue(mb, collationType, field);
    }

    String newRowLocationScanResultSetName() {
        this.currentRowScanResultSetName = this.newFieldName();
        return this.currentRowScanResultSetName;
    }

    String getRowLocationScanResultSetName() {
        return this.currentRowScanResultSetName;
    }
}

