/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata.plain;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.spatial.index.fielddata.CartesianShapeValues;
import org.elasticsearch.xpack.spatial.index.fielddata.LeafShapeFieldData;
import org.elasticsearch.xpack.spatial.search.aggregations.support.CartesianShapeValuesSourceType;

final class CartesianShapeDVAtomicShapeFieldData
extends LeafShapeFieldData<CartesianShapeValues> {
    private final LeafReader reader;
    private final String fieldName;

    CartesianShapeDVAtomicShapeFieldData(LeafReader reader, String fieldName, ToScriptFieldFactory<CartesianShapeValues> toScriptFieldFactory) {
        super(toScriptFieldFactory);
        this.reader = reader;
        this.fieldName = fieldName;
    }

    @Override
    public long ramBytesUsed() {
        return 0L;
    }

    @Override
    public CartesianShapeValues getShapeValues() {
        try {
            final BinaryDocValues binaryValues = DocValues.getBinary(this.reader, this.fieldName);
            final CartesianShapeValues.CartesianShapeValue shapeValue = new CartesianShapeValues.CartesianShapeValue();
            return new CartesianShapeValues(this){

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return binaryValues.advanceExact(doc);
                }

                @Override
                public ValuesSourceType valuesSourceType() {
                    return CartesianShapeValuesSourceType.instance();
                }

                @Override
                public CartesianShapeValues.CartesianShapeValue value() throws IOException {
                    shapeValue.reset(binaryValues.binaryValue());
                    return shapeValue;
                }
            };
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values", e);
        }
    }
}

