/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.mapper.IgnoredSourceFieldMapper;
import org.elasticsearch.index.mapper.SourceFieldMetrics;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceFilter;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;

public interface SourceLoader {
    public static final SourceLoader FROM_STORED_SOURCE = new Stored(null);

    public boolean reordersFieldValues();

    public Leaf leaf(LeafReader var1, int[] var2) throws IOException;

    public Set<String> requiredStoredFields();

    public static Source applySyntheticVectors(Source originalSource, List<SyntheticVectorPatch> patches) {
        Map<String, Object> newMap = originalSource.source();
        SourceLoader.applyPatches("", newMap, patches);
        return Source.fromMap(newMap, originalSource.sourceContentType());
    }

    private static void applyPatches(String rootPath, Map<String, Object> map, List<SyntheticVectorPatch> patches) {
        for (SyntheticVectorPatch patch : patches) {
            if (patch instanceof LeafSyntheticVectorPath) {
                LeafSyntheticVectorPath leaf = (LeafSyntheticVectorPath)patch;
                String key = SourceLoader.extractRelativePath(rootPath, leaf.fullPath());
                XContentMapValues.insertValue(key, map, leaf.value(), false);
                continue;
            }
            if (patch instanceof NestedSyntheticVectorPath) {
                NestedSyntheticVectorPath nested = (NestedSyntheticVectorPath)patch;
                String nestedPath = SourceLoader.extractRelativePath(rootPath, nested.fullPath());
                List<Map<?, ?>> nestedMaps = XContentMapValues.extractNestedSources(nestedPath, map);
                for (SyntheticVectorPatch childPatch : nested.children()) {
                    if (childPatch instanceof NestedOffsetSyntheticVectorPath) {
                        NestedOffsetSyntheticVectorPath offsetPatch = (NestedOffsetSyntheticVectorPath)childPatch;
                        Map<String, Object> nestedMap = XContentMapValues.nodeMapValue(nestedMaps.get(offsetPatch.offset()), nestedPath);
                        SourceLoader.applyPatches(nested.fullPath(), nestedMap, offsetPatch.children());
                        continue;
                    }
                    throw new IllegalStateException("Unexpected child patch type of " + patch.getClass().getSimpleName() + " in nested structure.");
                }
                continue;
            }
            throw new IllegalStateException("Unknown patch type: " + patch.getClass().getSimpleName());
        }
    }

    private static String extractRelativePath(String rootPath, String fullPath) {
        return rootPath.isEmpty() ? fullPath : fullPath.substring(rootPath.length() + 1);
    }

    public static sealed interface SyntheticVectorPatch
    permits NestedSyntheticVectorPath, NestedOffsetSyntheticVectorPath, LeafSyntheticVectorPath {
    }

    public record LeafSyntheticVectorPath(String fullPath, Object value) implements SyntheticVectorPatch
    {
    }

    public record NestedSyntheticVectorPath(String fullPath, List<SyntheticVectorPatch> children) implements SyntheticVectorPatch
    {
    }

    public record NestedOffsetSyntheticVectorPath(int offset, List<SyntheticVectorPatch> children) implements SyntheticVectorPatch
    {
    }

    public static class Stored
    implements SourceLoader {
        final SourceFilter filter;

        public Stored(@Nullable SourceFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean reordersFieldValues() {
            return false;
        }

        @Override
        public Leaf leaf(LeafReader reader, int[] docIdsInLeaf) {
            return new Leaf(){

                @Override
                public Source source(LeafStoredFieldLoader storedFields, int docId) throws IOException {
                    Source res = Source.fromBytes(storedFields.source());
                    return filter == null ? res : res.filter(filter);
                }

                @Override
                public void write(LeafStoredFieldLoader storedFields, int docId, XContentBuilder builder) throws IOException {
                    Source source = this.source(storedFields, docId);
                    builder.rawValue(source.internalSourceRef().streamInput(), source.sourceContentType());
                }
            };
        }

        @Override
        public Set<String> requiredStoredFields() {
            return Set.of();
        }
    }

    public static interface SyntheticVectorsLoader {
        public Leaf leaf(LeafReaderContext var1) throws IOException;

        public static interface Leaf {
            public void load(int var1, List<SyntheticVectorPatch> var2) throws IOException;
        }
    }

    public static class SyntheticVectors
    implements SourceLoader {
        final SourceLoader sourceLoader;
        final SyntheticVectorsLoader patchLoader;

        SyntheticVectors(@Nullable SourceFilter sourceFilter, SyntheticVectorsLoader patchLoader) {
            this.sourceLoader = sourceFilter == null ? FROM_STORED_SOURCE : new Stored(sourceFilter);
            this.patchLoader = patchLoader;
        }

        @Override
        public boolean reordersFieldValues() {
            return false;
        }

        @Override
        public Set<String> requiredStoredFields() {
            return this.sourceLoader.requiredStoredFields();
        }

        @Override
        public Leaf leaf(LeafReader reader, int[] docIdsInLeaf) throws IOException {
            final Leaf sourceLeaf = this.sourceLoader.leaf(reader, docIdsInLeaf);
            final SyntheticVectorsLoader.Leaf patchLeaf = this.patchLoader.leaf(reader.getContext());
            return new Leaf(){

                @Override
                public Source source(LeafStoredFieldLoader storedFields, int docId) throws IOException {
                    Source source = sourceLeaf.source(storedFields, docId);
                    if (patchLeaf == null) {
                        return source;
                    }
                    ArrayList<SyntheticVectorPatch> patches = new ArrayList<SyntheticVectorPatch>();
                    patchLeaf.load(docId, patches);
                    if (patches.size() == 0) {
                        return source;
                    }
                    return SourceLoader.applySyntheticVectors(source, patches);
                }

                @Override
                public void write(LeafStoredFieldLoader storedFields, int docId, XContentBuilder b) throws IOException {
                    throw new IllegalStateException("This operation is not allowed in the current context");
                }
            };
        }
    }

    public static abstract class DocValuesBasedSyntheticFieldLoader
    implements SyntheticFieldLoader {
        @Override
        public Stream<Map.Entry<String, SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
            return Stream.empty();
        }

        @Override
        public void reset() {
        }
    }

    public static interface SyntheticFieldLoader {
        public static final SyntheticFieldLoader NOTHING = new SyntheticFieldLoader(){

            @Override
            public Stream<Map.Entry<String, StoredFieldLoader>> storedFieldLoaders() {
                return Stream.of(new Map.Entry[0]);
            }

            @Override
            public DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
                return null;
            }

            @Override
            public boolean hasValue() {
                return false;
            }

            @Override
            public void write(XContentBuilder b) {
            }

            @Override
            public void reset() {
            }

            @Override
            public String fieldName() {
                return "";
            }
        };

        public Stream<Map.Entry<String, StoredFieldLoader>> storedFieldLoaders();

        public DocValuesLoader docValuesLoader(LeafReader var1, int[] var2) throws IOException;

        default public void prepare() {
        }

        public boolean hasValue();

        public void write(XContentBuilder var1) throws IOException;

        default public boolean setIgnoredValues(Map<String, List<IgnoredSourceFieldMapper.NameValue>> objectsWithIgnoredFields) {
            return false;
        }

        public String fieldName();

        public void reset();

        public static interface DocValuesLoader {
            public boolean advanceToDoc(int var1) throws IOException;
        }

        public static interface StoredFieldLoader {
            public void load(List<Object> var1);
        }
    }

    public static class Synthetic
    implements SourceLoader {
        private final SourceFilter filter;
        private final Supplier<SyntheticFieldLoader> syntheticFieldLoaderLeafSupplier;
        private final Set<String> requiredStoredFields;
        private final SourceFieldMetrics metrics;
        private final IgnoredSourceFieldMapper.IgnoredSourceFormat ignoredSourceFormat;

        public Synthetic(@Nullable SourceFilter filter, Supplier<SyntheticFieldLoader> fieldLoaderSupplier, SourceFieldMetrics metrics, IgnoredSourceFieldMapper.IgnoredSourceFormat ignoredSourceFormat) {
            this.syntheticFieldLoaderLeafSupplier = fieldLoaderSupplier;
            this.requiredStoredFields = this.syntheticFieldLoaderLeafSupplier.get().storedFieldLoaders().map(Map.Entry::getKey).collect(Collectors.toSet());
            this.metrics = metrics;
            this.filter = filter;
            this.ignoredSourceFormat = ignoredSourceFormat;
        }

        @Override
        public boolean reordersFieldValues() {
            return true;
        }

        @Override
        public Set<String> requiredStoredFields() {
            return this.requiredStoredFields;
        }

        @Override
        public Leaf leaf(LeafReader reader, int[] docIdsInLeaf) throws IOException {
            SyntheticFieldLoader loader = this.syntheticFieldLoaderLeafSupplier.get();
            return new LeafWithMetrics(new SyntheticLeaf(this.filter, loader, loader.docValuesLoader(reader, docIdsInLeaf), this.ignoredSourceFormat), this.metrics);
        }

        private record LeafWithMetrics(Leaf leaf, SourceFieldMetrics metrics) implements Leaf
        {
            @Override
            public Source source(LeafStoredFieldLoader storedFields, int docId) throws IOException {
                long startTime = this.metrics.getRelativeTimeSupplier().getAsLong();
                Source source = this.leaf.source(storedFields, docId);
                TimeValue duration = TimeValue.timeValueMillis(this.metrics.getRelativeTimeSupplier().getAsLong() - startTime);
                this.metrics.recordSyntheticSourceLoadLatency(duration);
                return source;
            }

            @Override
            public void write(LeafStoredFieldLoader storedFields, int docId, XContentBuilder b) throws IOException {
                long startTime = this.metrics.getRelativeTimeSupplier().getAsLong();
                this.leaf.write(storedFields, docId, b);
                TimeValue duration = TimeValue.timeValueMillis(this.metrics.getRelativeTimeSupplier().getAsLong() - startTime);
                this.metrics.recordSyntheticSourceLoadLatency(duration);
            }
        }

        private static class SyntheticLeaf
        implements Leaf {
            private final SourceFilter filter;
            private final SyntheticFieldLoader loader;
            private final SyntheticFieldLoader.DocValuesLoader docValuesLoader;
            private final Map<String, SyntheticFieldLoader.StoredFieldLoader> storedFieldLoaders;
            private final IgnoredSourceFieldMapper.IgnoredSourceFormat ignoredSourceFormat;

            private SyntheticLeaf(SourceFilter filter, SyntheticFieldLoader loader, SyntheticFieldLoader.DocValuesLoader docValuesLoader, IgnoredSourceFieldMapper.IgnoredSourceFormat ignoredSourceFormat) {
                this.filter = filter;
                this.loader = loader;
                this.docValuesLoader = docValuesLoader;
                this.storedFieldLoaders = Map.copyOf(loader.storedFieldLoaders().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
                this.ignoredSourceFormat = ignoredSourceFormat;
            }

            @Override
            public Source source(LeafStoredFieldLoader storedFieldLoader, int docId) throws IOException {
                try (XContentBuilder b = new XContentBuilder(JsonXContent.jsonXContent, new ByteArrayOutputStream());){
                    this.write(storedFieldLoader, docId, b);
                    Source source = Source.fromBytes(BytesReference.bytes(b), b.contentType());
                    return source;
                }
            }

            @Override
            public void write(LeafStoredFieldLoader storedFieldLoader, int docId, XContentBuilder b) throws IOException {
                for (Map.Entry<String, List<Object>> e : storedFieldLoader.storedFields().entrySet()) {
                    SyntheticFieldLoader.StoredFieldLoader loader = this.storedFieldLoaders.get(e.getKey());
                    if (loader == null) continue;
                    loader.load(e.getValue());
                }
                Map<String, List<IgnoredSourceFieldMapper.NameValue>> objectsWithIgnoredFields = this.ignoredSourceFormat.loadAllIgnoredFields(this.filter, storedFieldLoader.storedFields());
                if (objectsWithIgnoredFields != null) {
                    this.loader.setIgnoredValues(objectsWithIgnoredFields);
                }
                if (this.docValuesLoader != null) {
                    this.docValuesLoader.advanceToDoc(docId);
                }
                this.loader.prepare();
                if (this.loader.hasValue()) {
                    this.loader.write(b);
                } else {
                    b.startObject().endObject();
                }
            }
        }
    }

    public static interface Leaf {
        public Source source(LeafStoredFieldLoader var1, int var2) throws IOException;

        public void write(LeafStoredFieldLoader var1, int var2, XContentBuilder var3) throws IOException;
    }
}

