/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.node;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;

public class DiscoveryNodes
implements Iterable<DiscoveryNode>,
SimpleDiffable<DiscoveryNodes> {
    public static final DiscoveryNodes EMPTY_NODES = DiscoveryNodes.builder().build();
    private final long nodeLeftGeneration;
    private final Map<String, DiscoveryNode> nodes;
    private final Map<String, DiscoveryNode> dataNodes;
    private final Map<String, DiscoveryNode> masterNodes;
    private final Map<String, DiscoveryNode> ingestNodes;
    @Nullable
    private final String masterNodeId;
    @Nullable
    private final DiscoveryNode masterNode;
    @Nullable
    private final String localNodeId;
    @Nullable
    private final DiscoveryNode localNode;
    private final Version maxNodeVersion;
    private final Version minNodeVersion;
    private final IndexVersion maxDataNodeCompatibleIndexVersion;
    private final IndexVersion minSupportedIndexVersion;
    private final IndexVersion minReadOnlySupportedIndexVersion;
    private final Map<String, Set<String>> tiersToNodeIds;
    private static final Comparator<DiscoveryNode> MASTERS_FIRST_COMPARATOR = Comparator.comparingInt(n -> n.isMasterNode() ? 0 : 1).thenComparing(DiscoveryNode::getEphemeralId);

    private DiscoveryNodes(long nodeLeftGeneration, Map<String, DiscoveryNode> nodes, Map<String, DiscoveryNode> dataNodes, Map<String, DiscoveryNode> masterNodes, Map<String, DiscoveryNode> ingestNodes, @Nullable String masterNodeId, @Nullable String localNodeId, Version maxNodeVersion, Version minNodeVersion, IndexVersion maxDataNodeCompatibleIndexVersion, IndexVersion minSupportedIndexVersion, IndexVersion minReadOnlySupportedIndexVersion, Map<String, Set<String>> tiersToNodeIds) {
        this.nodeLeftGeneration = nodeLeftGeneration;
        this.nodes = nodes;
        this.dataNodes = dataNodes;
        this.masterNodes = masterNodes;
        this.ingestNodes = ingestNodes;
        this.masterNodeId = masterNodeId;
        DiscoveryNode discoveryNode = this.masterNode = masterNodeId == null ? null : nodes.get(masterNodeId);
        assert (masterNodeId == null == (this.masterNode == null));
        this.localNodeId = localNodeId;
        this.localNode = localNodeId == null ? null : nodes.get(localNodeId);
        this.minNodeVersion = minNodeVersion;
        this.maxNodeVersion = maxNodeVersion;
        this.maxDataNodeCompatibleIndexVersion = maxDataNodeCompatibleIndexVersion;
        this.minSupportedIndexVersion = minSupportedIndexVersion;
        this.minReadOnlySupportedIndexVersion = minReadOnlySupportedIndexVersion;
        assert (minReadOnlySupportedIndexVersion.onOrBefore(minSupportedIndexVersion));
        assert (localNodeId == null == (this.localNode == null));
        this.tiersToNodeIds = tiersToNodeIds;
    }

    public DiscoveryNodes withMasterNodeId(@Nullable String masterNodeId) {
        assert (masterNodeId == null || this.nodes.containsKey(masterNodeId)) : "unknown node [" + masterNodeId + "]";
        return new DiscoveryNodes(this.nodeLeftGeneration, this.nodes, this.dataNodes, this.masterNodes, this.ingestNodes, masterNodeId, this.localNodeId, this.maxNodeVersion, this.minNodeVersion, this.maxDataNodeCompatibleIndexVersion, this.minSupportedIndexVersion, this.minReadOnlySupportedIndexVersion, this.tiersToNodeIds);
    }

    @Override
    public Iterator<DiscoveryNode> iterator() {
        return this.nodes.values().iterator();
    }

    public Stream<DiscoveryNode> stream() {
        return this.nodes.values().stream();
    }

    public Collection<DiscoveryNode> getAllNodes() {
        return this.nodes.values();
    }

    public int size() {
        return this.nodes.size();
    }

    public boolean isLocalNodeElectedMaster() {
        if (this.localNodeId == null) {
            return false;
        }
        return this.localNodeId.equals(this.masterNodeId);
    }

    public Map<String, Set<String>> getTiersToNodeIds() {
        return this.tiersToNodeIds;
    }

    public int getSize() {
        return this.nodes.size();
    }

    public Map<String, DiscoveryNode> getNodes() {
        return this.nodes;
    }

    public Map<String, DiscoveryNode> getDataNodes() {
        return this.dataNodes;
    }

    public Map<String, DiscoveryNode> getMasterNodes() {
        return this.masterNodes;
    }

    public Map<String, DiscoveryNode> getIngestNodes() {
        return this.ingestNodes;
    }

    public Map<String, DiscoveryNode> getMasterAndDataNodes() {
        return DiscoveryNodes.filteredNodes(this.nodes, n -> n.canContainData() || n.isMasterNode());
    }

    public Map<String, DiscoveryNode> getCoordinatingOnlyNodes() {
        return DiscoveryNodes.filteredNodes(this.nodes, n -> !n.canContainData() && !n.isMasterNode() && !n.isIngestNode());
    }

    public Stream<DiscoveryNode> mastersFirstStream() {
        return this.nodes.values().stream().sorted(MASTERS_FIRST_COMPARATOR);
    }

    public DiscoveryNode get(String nodeId) {
        return this.nodes.get(nodeId);
    }

    public boolean nodeExists(String nodeId) {
        return this.nodes.containsKey(nodeId);
    }

    public boolean nodeExists(DiscoveryNode node) {
        DiscoveryNode existing = this.nodes.get(node.getId());
        return existing != null && existing.equals(node);
    }

    public boolean nodeExistsWithSameRoles(DiscoveryNode discoveryNode) {
        DiscoveryNode existing = this.nodes.get(discoveryNode.getId());
        return existing != null && existing.equals(discoveryNode) && existing.getRoles().equals(discoveryNode.getRoles());
    }

    public String getMasterNodeId() {
        return this.masterNodeId;
    }

    public String getLocalNodeId() {
        return this.localNodeId;
    }

    public DiscoveryNode getLocalNode() {
        return this.localNode;
    }

    @Nullable
    public DiscoveryNode getMasterNode() {
        return this.masterNode;
    }

    public DiscoveryNode findByAddress(TransportAddress address) {
        for (DiscoveryNode node : this.nodes.values()) {
            if (!node.getAddress().equals(address)) continue;
            return node;
        }
        return null;
    }

    public boolean hasByName(String name) {
        for (DiscoveryNode node : this.nodes.values()) {
            if (!node.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isMixedVersionCluster() {
        return !this.minNodeVersion.equals(this.maxNodeVersion);
    }

    public IndexVersion getMaxDataNodeCompatibleIndexVersion() {
        return this.maxDataNodeCompatibleIndexVersion;
    }

    public Version getMinNodeVersion() {
        return this.minNodeVersion;
    }

    public Version getMaxNodeVersion() {
        return this.maxNodeVersion;
    }

    public IndexVersion getMinSupportedIndexVersion() {
        return this.minSupportedIndexVersion;
    }

    public IndexVersion getMinReadOnlySupportedIndexVersion() {
        return this.minReadOnlySupportedIndexVersion;
    }

    public long getNodeLeftGeneration() {
        return this.nodeLeftGeneration;
    }

    public DiscoveryNode resolveNode(String node) {
        String[] resolvedNodeIds = this.resolveNodes(node);
        if (resolvedNodeIds.length > 1) {
            throw new IllegalArgumentException("resolved [" + node + "] into [" + resolvedNodeIds.length + "] nodes, where expected to be resolved to a single node");
        }
        if (resolvedNodeIds.length == 0) {
            throw new IllegalArgumentException("failed to resolve [" + node + "], no matching nodes");
        }
        return this.nodes.get(resolvedNodeIds[0]);
    }

    public String[] resolveNodes(String ... nodes) {
        if (nodes == null || nodes.length == 0) {
            return (String[])this.stream().map(DiscoveryNode::getId).toArray(String[]::new);
        }
        HashSet<String> resolvedNodesIds = Sets.newHashSetWithExpectedSize(nodes.length);
        for (String nodeId : nodes) {
            if (nodeId == null) {
                assert (nodeId != null) : "nodeId should not be null";
                continue;
            }
            if (nodeId.equals("_local")) {
                String localNodeId = this.getLocalNodeId();
                if (localNodeId == null) continue;
                resolvedNodesIds.add(localNodeId);
                continue;
            }
            if (nodeId.equals("_master")) {
                String masterNodeId = this.getMasterNodeId();
                if (masterNodeId == null) continue;
                resolvedNodesIds.add(masterNodeId);
                continue;
            }
            if (this.nodeExists(nodeId)) {
                resolvedNodesIds.add(nodeId);
                continue;
            }
            for (DiscoveryNode node : this) {
                if (!"_all".equals(nodeId) && !Regex.simpleMatch(nodeId, node.getName()) && !Regex.simpleMatch(nodeId, node.getHostAddress()) && !Regex.simpleMatch(nodeId, node.getHostName())) continue;
                resolvedNodesIds.add(node.getId());
            }
            int index = nodeId.indexOf(58);
            if (index == -1) continue;
            String matchAttrName = nodeId.substring(0, index);
            String matchAttrValue = nodeId.substring(index + 1);
            if (DiscoveryNodeRole.roles().stream().map(DiscoveryNodeRole::roleName).anyMatch(s -> s.equals(matchAttrName))) {
                DiscoveryNodeRole role = DiscoveryNodeRole.getRoleFromRoleName(matchAttrName);
                Predicate<Set> predicate = role.equals(DiscoveryNodeRole.DATA_ROLE) ? s -> s.stream().anyMatch(DiscoveryNodeRole::canContainData) : (role.canContainData() ? s -> s.stream().anyMatch(r -> r.equals(role) || r.equals(DiscoveryNodeRole.DATA_ROLE)) : s -> s.contains(role));
                Consumer<String> mutation = Booleans.parseBoolean(matchAttrValue, true) ? resolvedNodesIds::add : resolvedNodesIds::remove;
                for (DiscoveryNode node : this) {
                    if (!predicate.test(node.getRoles())) continue;
                    mutation.accept(node.getId());
                }
                continue;
            }
            if ("coordinating_only".equals(matchAttrName)) {
                if (Booleans.parseBoolean(matchAttrValue, true)) {
                    resolvedNodesIds.addAll(this.getCoordinatingOnlyNodes().keySet());
                    continue;
                }
                resolvedNodesIds.removeAll(this.getCoordinatingOnlyNodes().keySet());
                continue;
            }
            for (DiscoveryNode node : this) {
                for (DiscoveryNodeRole discoveryNodeRole : Sets.difference(node.getRoles(), DiscoveryNodeRole.roles())) {
                    if (!discoveryNodeRole.roleName().equals(matchAttrName)) continue;
                    if (Booleans.parseBoolean(matchAttrValue, true)) {
                        resolvedNodesIds.add(node.getId());
                        continue;
                    }
                    resolvedNodesIds.remove(node.getId());
                }
            }
            for (DiscoveryNode node : this) {
                for (Map.Entry entry : node.getAttributes().entrySet()) {
                    String attrName = (String)entry.getKey();
                    String attrValue = (String)entry.getValue();
                    if (!Regex.simpleMatch(matchAttrName, attrName) || !Regex.simpleMatch(matchAttrValue, attrValue)) continue;
                    resolvedNodesIds.add(node.getId());
                }
            }
        }
        return resolvedNodesIds.toArray(Strings.EMPTY_ARRAY);
    }

    public Delta delta(DiscoveryNodes other) {
        if (this == other) {
            return new Delta(this.masterNode, this.masterNode, this.localNodeId, List.of(), List.of());
        }
        ArrayList<DiscoveryNode> removed = new ArrayList<DiscoveryNode>();
        ArrayList<DiscoveryNode> added = new ArrayList<DiscoveryNode>();
        for (DiscoveryNode node : other) {
            if (this.nodeExists(node)) continue;
            removed.add(node);
        }
        for (DiscoveryNode node : this) {
            if (other.nodeExists(node)) continue;
            added.add(node);
        }
        return new Delta(other.getMasterNode(), this.getMasterNode(), this.localNodeId, Collections.unmodifiableList(removed), Collections.unmodifiableList(added));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("nodes (node-left generation: ").append(this.nodeLeftGeneration).append("):\n");
        for (DiscoveryNode node : this) {
            sb.append("   ").append(node);
            if (node == this.getLocalNode()) {
                sb.append(", local");
            }
            if (node == this.getMasterNode()) {
                sb.append(", master");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.masterNodeId);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
            out.writeVLong(this.nodeLeftGeneration);
        }
        out.writeCollection(this.nodes.values());
    }

    public static DiscoveryNodes readFrom(StreamInput in, DiscoveryNode localNode) throws IOException {
        Builder builder = new Builder();
        if (in.readBoolean()) {
            builder.masterNodeId(in.readString());
        }
        if (localNode != null) {
            builder.localNodeId(localNode.getId());
        }
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
            builder.nodeLeftGeneration(in.readVLong());
        }
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            DiscoveryNode node = new DiscoveryNode(in);
            if (localNode != null && node.getId().equals(localNode.getId())) {
                node = localNode;
            }
            assert (builder.validateAdd(node) == null) : "building disco nodes from network doesn't pass preflight: " + builder.validateAdd(node);
            builder.putUnsafe(node);
        }
        return builder.build();
    }

    public static Diff<DiscoveryNodes> readDiffFrom(StreamInput in, DiscoveryNode localNode) throws IOException {
        return SimpleDiffable.readDiffFrom((StreamInput in1) -> DiscoveryNodes.readFrom(in1, localNode), in);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DiscoveryNodes nodes) {
        return new Builder(nodes);
    }

    private static Map<String, DiscoveryNode> filteredNodes(Map<String, DiscoveryNode> nodes, Predicate<DiscoveryNode> predicate) {
        return nodes.entrySet().stream().filter(e -> predicate.test((DiscoveryNode)e.getValue())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static void addCommaSeparatedNodesWithoutAttributes(Iterator<DiscoveryNode> iterator, StringBuilder stringBuilder) {
        while (iterator.hasNext()) {
            iterator.next().appendDescriptionWithoutAttributes(stringBuilder);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
    }

    public static class Delta {
        private final String localNodeId;
        @Nullable
        private final DiscoveryNode previousMasterNode;
        @Nullable
        private final DiscoveryNode newMasterNode;
        private final List<DiscoveryNode> removed;
        private final List<DiscoveryNode> added;

        private Delta(@Nullable DiscoveryNode previousMasterNode, @Nullable DiscoveryNode newMasterNode, String localNodeId, List<DiscoveryNode> removed, List<DiscoveryNode> added) {
            this.previousMasterNode = previousMasterNode;
            this.newMasterNode = newMasterNode;
            this.localNodeId = localNodeId;
            this.removed = removed;
            this.added = added;
        }

        public boolean hasChanges() {
            return this.masterNodeChanged() || !this.removed.isEmpty() || !this.added.isEmpty();
        }

        public boolean masterNodeChanged() {
            return !Objects.equals(this.newMasterNode, this.previousMasterNode);
        }

        @Nullable
        public DiscoveryNode previousMasterNode() {
            return this.previousMasterNode;
        }

        @Nullable
        public DiscoveryNode newMasterNode() {
            return this.newMasterNode;
        }

        public boolean removed() {
            return !this.removed.isEmpty();
        }

        public List<DiscoveryNode> removedNodes() {
            return this.removed;
        }

        public boolean added() {
            return !this.added.isEmpty();
        }

        public List<DiscoveryNode> addedNodes() {
            return this.added;
        }

        public String toString() {
            return this.shortSummary();
        }

        public String shortSummary() {
            Iterator<DiscoveryNode> addedNodesIterator;
            StringBuilder summary = new StringBuilder();
            if (this.masterNodeChanged()) {
                summary.append("master node changed {previous [");
                if (this.previousMasterNode != null) {
                    this.previousMasterNode.appendDescriptionWithoutAttributes(summary);
                }
                summary.append("], current [");
                if (this.newMasterNode != null) {
                    this.newMasterNode.appendDescriptionWithoutAttributes(summary);
                }
                summary.append("]}");
            }
            if (this.removed()) {
                if (summary.length() > 0) {
                    summary.append(", ");
                }
                summary.append("removed {");
                DiscoveryNodes.addCommaSeparatedNodesWithoutAttributes(this.removedNodes().iterator(), summary);
                summary.append('}');
            }
            if (this.added() && (addedNodesIterator = this.addedNodes().stream().filter(node -> !node.getId().equals(this.localNodeId)).iterator()).hasNext()) {
                if (summary.length() > 0) {
                    summary.append(", ");
                }
                summary.append("added {");
                DiscoveryNodes.addCommaSeparatedNodesWithoutAttributes(addedNodesIterator, summary);
                summary.append('}');
            }
            return summary.toString();
        }
    }

    public static class Builder {
        private final Map<String, DiscoveryNode> nodes;
        private String masterNodeId;
        private String localNodeId;
        private boolean removedNode;
        private final long oldNodeLeftGeneration;
        @Nullable
        private Long nodeLeftGeneration;
        private boolean resetNodeLeftGeneration;

        public Builder() {
            this.nodes = new HashMap<String, DiscoveryNode>();
            this.oldNodeLeftGeneration = 0L;
        }

        public Builder(DiscoveryNodes nodes) {
            this.masterNodeId = nodes.getMasterNodeId();
            this.localNodeId = nodes.getLocalNodeId();
            this.nodes = new HashMap<String, DiscoveryNode>(nodes.getNodes());
            this.oldNodeLeftGeneration = nodes.nodeLeftGeneration;
        }

        public Builder add(DiscoveryNode node) {
            String preflight = this.validateAdd(node);
            if (preflight != null) {
                throw new IllegalArgumentException(preflight);
            }
            this.putUnsafe(node);
            return this;
        }

        @Nullable
        public DiscoveryNode get(String nodeId) {
            return this.nodes.get(nodeId);
        }

        private void putUnsafe(DiscoveryNode node) {
            this.nodes.put(node.getId(), node);
        }

        public Builder remove(String nodeId) {
            if (this.nodes.remove(nodeId) != null) {
                this.removedNode = true;
            }
            return this;
        }

        public Builder remove(DiscoveryNode node) {
            if (node.equals(this.nodes.get(node.getId()))) {
                this.nodes.remove(node.getId());
                this.removedNode = true;
            }
            return this;
        }

        public Builder masterNodeId(String masterNodeId) {
            this.masterNodeId = masterNodeId;
            return this;
        }

        public Builder localNodeId(String localNodeId) {
            this.localNodeId = localNodeId;
            return this;
        }

        private String validateAdd(DiscoveryNode node) {
            for (DiscoveryNode existingNode : this.nodes.values()) {
                if (node.getAddress().equals(existingNode.getAddress()) && !node.getId().equals(existingNode.getId())) {
                    return "can't add node " + String.valueOf(node) + ", found existing node " + String.valueOf(existingNode) + " with same address";
                }
                if (!node.getId().equals(existingNode.getId()) || node.equals(existingNode)) continue;
                return "can't add node " + String.valueOf(node) + ", found existing node " + String.valueOf(existingNode) + " with the same id but is a different node instance";
            }
            return null;
        }

        private static <T extends Comparable<T>> T min(T t1, T t2) {
            assert (t2 != null);
            return t1 == null || t1.compareTo(t2) > 0 ? t2 : t1;
        }

        private static <T extends Comparable<T>> T max(T t1, T t2) {
            assert (t2 != null);
            return t1 == null || t1.compareTo(t2) < 0 ? t2 : t1;
        }

        public DiscoveryNodes build() {
            long newNodeLeftGeneration;
            VersionId minNodeVersion = null;
            Version maxNodeVersion = null;
            IndexVersion maxDataNodeCompatibleIndexVersion = null;
            IndexVersion minSupportedIndexVersion = null;
            IndexVersion minReadOnlySupportedIndexVersion = null;
            for (Map.Entry<String, DiscoveryNode> nodeEntry : this.nodes.entrySet()) {
                DiscoveryNode discoNode = nodeEntry.getValue();
                Version version = discoNode.getVersion();
                if (discoNode.canContainData() || discoNode.isMasterNode()) {
                    maxDataNodeCompatibleIndexVersion = Builder.min(maxDataNodeCompatibleIndexVersion, discoNode.getMaxIndexVersion());
                }
                minNodeVersion = Builder.min(minNodeVersion, version);
                maxNodeVersion = Builder.max(maxNodeVersion, version);
                minSupportedIndexVersion = Builder.max(minSupportedIndexVersion, discoNode.getMinIndexVersion());
                minReadOnlySupportedIndexVersion = Builder.max(minReadOnlySupportedIndexVersion, discoNode.getMinReadOnlyIndexVersion());
            }
            if (minNodeVersion == null || minNodeVersion.before(Version.V_8_9_0)) {
                assert (this.nodeLeftGeneration == null || this.nodeLeftGeneration == 0L);
                newNodeLeftGeneration = 0L;
            } else if (this.nodeLeftGeneration != null) {
                assert (!this.removedNode);
                assert (!this.resetNodeLeftGeneration);
                newNodeLeftGeneration = this.nodeLeftGeneration;
            } else {
                newNodeLeftGeneration = this.resetNodeLeftGeneration ? 0L : (this.removedNode ? this.oldNodeLeftGeneration + 1L : this.oldNodeLeftGeneration);
            }
            Map<String, DiscoveryNode> dataNodes = DiscoveryNodes.filteredNodes(this.nodes, DiscoveryNode::canContainData);
            return new DiscoveryNodes(newNodeLeftGeneration, Map.copyOf(this.nodes), dataNodes, DiscoveryNodes.filteredNodes(this.nodes, DiscoveryNode::isMasterNode), DiscoveryNodes.filteredNodes(this.nodes, DiscoveryNode::isIngestNode), this.masterNodeId, this.localNodeId, Objects.requireNonNullElse(maxNodeVersion, Version.CURRENT), Objects.requireNonNullElse(minNodeVersion, Version.CURRENT.minimumCompatibilityVersion()), Objects.requireNonNullElse(maxDataNodeCompatibleIndexVersion, IndexVersion.current()), Objects.requireNonNullElse(minSupportedIndexVersion, IndexVersions.MINIMUM_COMPATIBLE), Objects.requireNonNullElse(minReadOnlySupportedIndexVersion, IndexVersions.MINIMUM_READONLY_COMPATIBLE), Builder.computeTiersToNodesMap(dataNodes));
        }

        private static Map<String, Set<String>> computeTiersToNodesMap(Map<String, DiscoveryNode> dataNodes) {
            HashMap<String, Set> tiersToNodes = new HashMap<String, Set>(DataTier.ALL_DATA_TIERS.size() + 1);
            for (DiscoveryNode discoveryNode : dataNodes.values()) {
                if (discoveryNode.hasRole(DiscoveryNodeRole.DATA_ROLE.roleName())) {
                    tiersToNodes.computeIfAbsent(DiscoveryNodeRole.DATA_ROLE.roleName(), key -> new HashSet()).add(discoveryNode.getId());
                }
                for (String role : DataTier.ALL_DATA_TIERS) {
                    if (!discoveryNode.hasRole(role)) continue;
                    tiersToNodes.computeIfAbsent(role, key -> new HashSet()).add(discoveryNode.getId());
                }
            }
            for (Map.Entry entry : tiersToNodes.entrySet()) {
                entry.setValue(Collections.unmodifiableSet((Set)entry.getValue()));
            }
            return Collections.unmodifiableMap(tiersToNodes);
        }

        public boolean isLocalNodeElectedMaster() {
            return this.masterNodeId != null && this.masterNodeId.equals(this.localNodeId);
        }

        void nodeLeftGeneration(long nodeLeftGeneration) {
            assert (this.nodeLeftGeneration == null) : nodeLeftGeneration + " vs " + this.nodeLeftGeneration;
            this.nodeLeftGeneration = nodeLeftGeneration;
        }

        public void resetNodeLeftGeneration() {
            assert (!this.resetNodeLeftGeneration);
            this.resetNodeLeftGeneration = true;
        }
    }
}

