/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.sampling;

import java.io.IOException;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record SamplingConfiguration(double rate, Integer maxSamples, ByteSizeValue maxSize, TimeValue timeToLive, String condition) implements ToXContentObject,
SimpleDiffable<SamplingConfiguration>
{
    public static final String TYPE = "sampling_configuration";
    private static final String RATE_FIELD_NAME = "rate";
    private static final String MAX_SAMPLES_FIELD_NAME = "max_samples";
    private static final String MAX_SIZE_IN_BYTES_FIELD_NAME = "max_size_in_bytes";
    private static final String MAX_SIZE_FIELD_NAME = "max_size";
    private static final String TIME_TO_LIVE_IN_MILLIS_FIELD_NAME = "time_to_live_in_millis";
    private static final String TIME_TO_LIVE_FIELD_NAME = "time_to_live";
    private static final String CONDITION_FIELD_NAME = "if";
    public static final int MAX_SAMPLES_LIMIT = 10000;
    public static final long MAX_SIZE_LIMIT_GIGABYTES = 5L;
    public static final long MAX_TIME_TO_LIVE_DAYS = 30L;
    public static final int DEFAULT_MAX_SAMPLES = 100;
    public static final long DEFAULT_MAX_SIZE_GIGABYTES = 1L;
    public static final long DEFAULT_TIME_TO_LIVE_DAYS = 10L;
    public static final String INVALID_RATE_MESSAGE = "rate must be greater than 0 and less than or equal to 1";
    public static final String INVALID_MAX_SAMPLES_MIN_MESSAGE = "maxSamples must be greater than 0";
    public static final String INVALID_MAX_SAMPLES_MAX_MESSAGE = "maxSamples must be less than or equal to 10000";
    public static final String INVALID_MAX_SIZE_MIN_MESSAGE = "maxSize must be greater than 0";
    public static final String INVALID_MAX_SIZE_MAX_MESSAGE = "maxSize must be less than or equal to 5GB";
    public static final String INVALID_TIME_TO_LIVE_MIN_MESSAGE = "timeToLive must be greater than 0";
    public static final String INVALID_TIME_TO_LIVE_MAX_MESSAGE = "timeToLive must be less than or equal to 30 days";
    public static final String INVALID_CONDITION_MESSAGE = "condition script, if provided, must not be empty";
    private static final ConstructingObjectParser<SamplingConfiguration, Void> PARSER = new ConstructingObjectParser("sampling_configuration", false, args -> {
        Double rate = (Double)args[0];
        Integer maxSamples = (Integer)args[1];
        ByteSizeValue humanReadableMaxSize = (ByteSizeValue)args[2];
        ByteSizeValue rawMaxSize = (ByteSizeValue)args[3];
        TimeValue humanReadableTimeToLive = (TimeValue)args[4];
        TimeValue rawTimeToLive = (TimeValue)args[5];
        String condition = (String)args[6];
        return new SamplingConfiguration(rate, maxSamples, SamplingConfiguration.determineValue(humanReadableMaxSize, rawMaxSize), SamplingConfiguration.determineValue(humanReadableTimeToLive, rawTimeToLive), condition);
    });

    public SamplingConfiguration(double rate, Integer maxSamples, ByteSizeValue maxSize, TimeValue timeToLive, String condition) {
        SamplingConfiguration.validateInputs(rate, maxSamples, maxSize, timeToLive, condition);
        this.rate = rate;
        this.maxSamples = maxSamples == null ? 100 : maxSamples;
        this.maxSize = maxSize == null ? ByteSizeValue.ofGb(1L) : maxSize;
        this.timeToLive = timeToLive == null ? TimeValue.timeValueDays(10L) : timeToLive;
        this.condition = condition;
    }

    public SamplingConfiguration(StreamInput in) throws IOException {
        this(in.readDouble(), in.readInt(), ByteSizeValue.readFrom(in), in.readTimeValue(), in.readOptionalString());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.rate);
        out.writeInt(this.maxSamples);
        out.writeWriteable(this.maxSize);
        out.writeTimeValue(this.timeToLive);
        out.writeOptionalString(this.condition);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(RATE_FIELD_NAME, this.rate);
        builder.field(MAX_SAMPLES_FIELD_NAME, this.maxSamples);
        builder.humanReadableField(MAX_SIZE_IN_BYTES_FIELD_NAME, MAX_SIZE_FIELD_NAME, this.maxSize);
        builder.humanReadableField(TIME_TO_LIVE_IN_MILLIS_FIELD_NAME, TIME_TO_LIVE_FIELD_NAME, this.timeToLive);
        if (this.condition != null) {
            builder.field(CONDITION_FIELD_NAME, this.condition);
        }
        builder.endObject();
        return builder;
    }

    public static SamplingConfiguration fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public static Diff<SamplingConfiguration> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(SamplingConfiguration::new, in);
    }

    private static void validateInputs(double rate, Integer maxSamples, ByteSizeValue maxSize, TimeValue timeToLive, String condition) {
        Comparable<ByteSizeValue> maxLimit;
        if (rate <= 0.0 || rate > 1.0) {
            throw new IllegalArgumentException(INVALID_RATE_MESSAGE);
        }
        if (maxSamples != null) {
            if (maxSamples <= 0) {
                throw new IllegalArgumentException(INVALID_MAX_SAMPLES_MIN_MESSAGE);
            }
            if (maxSamples > 10000) {
                throw new IllegalArgumentException(INVALID_MAX_SAMPLES_MAX_MESSAGE);
            }
        }
        if (maxSize != null) {
            if (maxSize.compareTo(ByteSizeValue.ZERO) <= 0) {
                throw new IllegalArgumentException(INVALID_MAX_SIZE_MIN_MESSAGE);
            }
            maxLimit = ByteSizeValue.ofGb(5L);
            if (maxSize.compareTo((ByteSizeValue)maxLimit) > 0) {
                throw new IllegalArgumentException(INVALID_MAX_SIZE_MAX_MESSAGE);
            }
        }
        if (timeToLive != null) {
            if (timeToLive.compareTo(TimeValue.ZERO) <= 0) {
                throw new IllegalArgumentException(INVALID_TIME_TO_LIVE_MIN_MESSAGE);
            }
            maxLimit = TimeValue.timeValueDays(30L);
            if (timeToLive.compareTo((TimeValue)maxLimit) > 0) {
                throw new IllegalArgumentException(INVALID_TIME_TO_LIVE_MAX_MESSAGE);
            }
        }
        if (condition != null && condition.isEmpty()) {
            throw new IllegalArgumentException(INVALID_CONDITION_MESSAGE);
        }
    }

    private static <T> T determineValue(T humanReadableValue, T rawValue) {
        if (humanReadableValue == null && rawValue == null) {
            return null;
        }
        return humanReadableValue != null ? humanReadableValue : rawValue;
    }

    static {
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), new ParseField(RATE_FIELD_NAME, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField(MAX_SAMPLES_FIELD_NAME, new String[0]));
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue(p.text(), MAX_SIZE_FIELD_NAME), new ParseField(MAX_SIZE_FIELD_NAME, new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.ofBytes(p.longValue()), new ParseField(MAX_SIZE_IN_BYTES_FIELD_NAME, new String[0]), ObjectParser.ValueType.LONG);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TimeValue.parseTimeValue(p.text(), TIME_TO_LIVE_FIELD_NAME), new ParseField(TIME_TO_LIVE_FIELD_NAME, new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TimeValue.timeValueMillis(p.longValue()), new ParseField(TIME_TO_LIVE_IN_MILLIS_FIELD_NAME, new String[0]), ObjectParser.ValueType.LONG);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(CONDITION_FIELD_NAME, new String[0]));
    }
}

