/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.ResolvedIndexExpression;

public record ResolvedIndexExpressions(List<ResolvedIndexExpression> expressions) {
    public List<String> getLocalIndicesList() {
        return this.expressions.stream().flatMap(e -> e.localExpressions().expressions().stream()).toList();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<ResolvedIndexExpression> expressions = new ArrayList<ResolvedIndexExpression>();

        public void addLocalExpressions(String original, HashSet<String> localExpressions, ResolvedIndexExpression.LocalIndexResolutionResult resolutionResult) {
            Objects.requireNonNull(original);
            Objects.requireNonNull(localExpressions);
            Objects.requireNonNull(resolutionResult);
            this.expressions.add(new ResolvedIndexExpression(original, new ResolvedIndexExpression.LocalExpressions(localExpressions, resolutionResult, null), new HashSet<String>()));
        }

        public void excludeFromLocalExpressions(Set<String> expressionsToExclude) {
            Objects.requireNonNull(expressionsToExclude);
            if (!expressionsToExclude.isEmpty()) {
                for (ResolvedIndexExpression prior : this.expressions) {
                    prior.localExpressions().expressions().removeAll(expressionsToExclude);
                }
            }
        }

        public ResolvedIndexExpressions build() {
            return new ResolvedIndexExpressions(this.expressions);
        }
    }
}

