/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.RankFeatureFunction;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class RankFeatureFunctionLogarithm
extends RankFeatureFunction
implements JsonpSerializable {
    private final float scalingFactor;
    public static final JsonpDeserializer<RankFeatureFunctionLogarithm> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankFeatureFunctionLogarithm::setupRankFeatureFunctionLogarithmDeserializer);

    private RankFeatureFunctionLogarithm(Builder builder) {
        this.scalingFactor = ApiTypeHelper.requireNonNull(builder.scalingFactor, (Object)this, "scalingFactor", 0.0f);
    }

    public static RankFeatureFunctionLogarithm of(Function<Builder, ObjectBuilder<RankFeatureFunctionLogarithm>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final float scalingFactor() {
        return this.scalingFactor;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("scaling_factor");
        generator.write(this.scalingFactor);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRankFeatureFunctionLogarithmDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::scalingFactor, JsonpDeserializer.floatDeserializer(), "scaling_factor");
    }

    public static class Builder
    extends RankFeatureFunction.AbstractBuilder<Builder>
    implements ObjectBuilder<RankFeatureFunctionLogarithm> {
        private Float scalingFactor;

        public final Builder scalingFactor(float value) {
            this.scalingFactor = Float.valueOf(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RankFeatureFunctionLogarithm build() {
            this._checkSingleUse();
            return new RankFeatureFunctionLogarithm(this);
        }
    }
}

