/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

public final class LengthOperatorNode
extends UnaryOperatorNode {
    private int parameterType;
    private int parameterWidth;

    LengthOperatorNode(ValueNode operator, ContextManager cm) throws StandardException {
        super(operator, cm);
        String op = "char_length";
        String methodNam = "charLength";
        this.parameterType = 12;
        this.parameterWidth = 32672;
        this.setOperator(op);
        this.setMethodName(methodNam);
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        this.bindOperand(fromList, subqueryList, aggregates);
        TypeId operandType = this.operand.getTypeId();
        switch (operandType.getJDBCTypeId()) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                break;
            }
            default: {
                throw StandardException.newException((String)"42X25", (Object[])new Object[]{this.getOperatorString(), operandType.getSQLTypeName()});
            }
        }
        this.setType(new DataTypeDescriptor(TypeId.INTEGER_ID, this.operand.getTypeServices().isNullable()));
        return this;
    }

    @Override
    void bindParameter() throws StandardException {
        this.operand.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(this.parameterType, true, this.parameterWidth));
    }

    @Override
    String getReceiverInterfaceName() {
        return "org.apache.derby.iapi.types.ConcatableDataValue";
    }
}

