"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsCellComponent = exports.ActionsCell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _lodash = require("lodash");
var _stateful_event_context = require("../../../common/components/events_viewer/stateful_event_context");
var _use_license = require("../../../common/hooks/use_license");
var _default_config = require("./default_config");
var _row_action = require("../../../common/components/control_columns/row_action");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_table/actions_cell.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const onRowSelected = () => {};
const ActionsCellComponent = ({
  tableType = _securitysolutionDataTable.TableId.alertsOnAlertsPage,
  rowIndex,
  isDetails,
  isExpanded,
  isExpandable,
  colIndex,
  setCellProps,
  ecsAlert: alert,
  legacyAlert,
  setIsActionLoading,
  refresh: alertsTableRefresh,
  clearSelection,
  leadingControlColumn
}) => {
  const license = (0, _use_license.useLicense)();
  const defaults = (0, _react.useMemo)(() => (0, _default_config.getAlertsDefaultModel)(license), [license]);
  const selectTableById = (0, _react.useMemo)(() => (0, _securitysolutionDataTable.getTableByIdSelector)(), []);
  const {
    columns: columnHeaders,
    showCheckboxes,
    selectedEventIds,
    loadingEventIds
  } = (0, _reactRedux.useSelector)(state => {
    var _selectTableById;
    return (_selectTableById = selectTableById(state, tableType)) !== null && _selectTableById !== void 0 ? _selectTableById : defaults;
  });
  const eventContext = (0, _react.useContext)(_stateful_event_context.StatefulEventContext);
  const timelineItem = (0, _react.useMemo)(() => ({
    _id: alert._id,
    _index: alert._index,
    ecs: alert,
    data: legacyAlert
  }), [alert, legacyAlert]);
  const setEventsLoading = (0, _react.useCallback)(({
    isLoading
  }) => {
    if (!isLoading) {
      clearSelection();
      return;
    }
    if (setIsActionLoading) setIsActionLoading(isLoading);
  }, [clearSelection, setIsActionLoading]);
  return /*#__PURE__*/_react.default.createElement(_row_action.RowAction, {
    columnId: `actions-${rowIndex}`,
    columnHeaders: columnHeaders,
    controlColumn: leadingControlColumn,
    data: timelineItem,
    disabled: false,
    index: rowIndex,
    isDetails: isDetails,
    isExpanded: isExpanded,
    isEventViewer: false,
    isExpandable: isExpandable,
    loadingEventIds: loadingEventIds,
    onRowSelected: onRowSelected,
    rowIndex: rowIndex,
    colIndex: colIndex,
    pageRowIndex: rowIndex,
    selectedEventIds: selectedEventIds,
    setCellProps: setCellProps,
    showCheckboxes: showCheckboxes,
    onRuleChange: eventContext === null || eventContext === void 0 ? void 0 : eventContext.onRuleChange,
    tabType: 'query',
    tableId: tableType,
    width: 0,
    setEventsLoading: setEventsLoading,
    setEventsDeleted: _lodash.noop,
    refetch: alertsTableRefresh,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  });
};
exports.ActionsCellComponent = ActionsCellComponent;
const ActionsCell = exports.ActionsCell = /*#__PURE__*/(0, _react.memo)(ActionsCellComponent);