"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableSection = exports.TABLE_SECTION_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _use_group_take_action_items = require("../../../hooks/alerts_table/use_group_take_action_items");
var _grouping_settings = require("../../alerts_table/grouping_settings");
var _use_data_table_filters = require("../../../../common/hooks/use_data_table_filters");
var _use_selector = require("../../../../common/hooks/use_selector");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _inputs = require("../../../../common/store/inputs");
var _user_info = require("../../user_info");
var _use_lists_config = require("../../../containers/detection_engine/lists/use_lists_config");
var _default_config = require("../../alerts_table/default_config");
var _alerts_grouping = require("../../alerts_table/alerts_grouping");
var _alerts_table = require("../../alerts_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts/table/table_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TABLE_SECTION_TEST_ID = exports.TABLE_SECTION_TEST_ID = 'alerts-page-table-section';
/**
 * Renders the alerts table with grouping functionality in the alerts page.
 */
const TableSection = exports.TableSection = /*#__PURE__*/(0, _react.memo)(({
  assignees,
  dataView,
  dataViewSpec,
  pageFilters,
  statusFilter
}) => {
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _inputs.inputsSelectors.globalFiltersQuerySelector(), []);
  const globalFilters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _inputs.inputsSelectors.globalQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const {
    to,
    from
  } = (0, _use_global_time.useGlobalTime)();
  const [{
    loading: userInfoLoading,
    hasIndexWrite,
    hasIndexMaintenance
  }] = (0, _user_info.useUserData)();
  const {
    loading: listsConfigLoading
  } = (0, _use_lists_config.useListsConfig)();
  const {
    showBuildingBlockAlerts,
    showOnlyThreatIndicatorAlerts
  } = (0, _use_data_table_filters.useDataTableFilters)(_securitysolutionDataTable.TableId.alertsOnAlertsPage);

  // AlertsTable manages global filters itself, so not including `filters`
  const defaultFilters = (0, _react.useMemo)(() => [...(0, _default_config.buildShowBuildingBlockFilter)(showBuildingBlockAlerts), ...(0, _default_config.buildThreatMatchFilter)(showOnlyThreatIndicatorAlerts), ...(pageFilters !== null && pageFilters !== void 0 ? pageFilters : []), ...(0, _default_config.buildAlertAssigneesFilter)(assignees)], [assignees, showBuildingBlockAlerts, showOnlyThreatIndicatorAlerts, pageFilters]);
  const isLoading = (0, _react.useMemo)(() => userInfoLoading || listsConfigLoading || !Array.isArray(pageFilters), [pageFilters, listsConfigLoading, userInfoLoading]);
  const renderAlertTable = (0, _react.useCallback)(groupingFilters => {
    return /*#__PURE__*/_react.default.createElement(_alerts_table.AlertsTable, {
      tableType: _securitysolutionDataTable.TableId.alertsOnAlertsPage,
      inputFilters: [...defaultFilters, ...groupingFilters],
      isLoading: isLoading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 11
      }
    });
  }, [defaultFilters, isLoading]);
  const groupTakeActionItems = (0, _use_group_take_action_items.useGroupTakeActionsItems)({
    currentStatus: statusFilter,
    showAlertStatusActions: Boolean(hasIndexWrite) && Boolean(hasIndexMaintenance)
  });
  const accordionExtraActionGroupStats = (0, _react.useMemo)(() => ({
    aggregations: _grouping_settings.defaultGroupStatsAggregations,
    renderer: _grouping_settings.defaultGroupStatsRenderer
  }), []);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": TABLE_SECTION_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_alerts_grouping.GroupedAlertsTable, {
    accordionButtonContent: _grouping_settings.defaultGroupTitleRenderers,
    accordionExtraActionGroupStats: accordionExtraActionGroupStats,
    dataView: dataView,
    dataViewSpec: dataViewSpec,
    defaultFilters: defaultFilters,
    defaultGroupingOptions: _grouping_settings.defaultGroupingOptions,
    from: from,
    globalFilters: globalFilters,
    globalQuery: query,
    groupTakeActionItems: groupTakeActionItems,
    loading: isLoading,
    renderChildComponent: renderAlertTable,
    tableId: _securitysolutionDataTable.TableId.alertsOnAlertsPage,
    to: to,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }));
});
TableSection.displayName = 'TableSection';