"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SECURITY_SOLUTION_PAGE_WRAPPER_TEST_ID = exports.CONTENT_TEST_ID = exports.AlertsPageContent = void 0;
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/timelines-plugin/public");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _translations = require("../../pages/alerts/translations");
var _use_selector = require("../../../common/hooks/use_selector");
var _header_page = require("../../../common/components/header_page");
var _kpis_section = require("./kpis/kpis_section");
var _filters_section = require("./filters/filters_section");
var _header_section = require("./header/header_section");
var _search_bar_section = require("./search_bar/search_bar_section");
var _table_section = require("./table/table_section");
var _page_wrapper = require("../../../common/components/page_wrapper");
var _use_full_screen = require("../../../common/containers/use_full_screen");
var _display = require("../../../explore/hosts/pages/display");
var _helpers = require("../../../timelines/components/timeline/helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts/content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CONTENT_TEST_ID = exports.CONTENT_TEST_ID = 'alerts-page-content';
const SECURITY_SOLUTION_PAGE_WRAPPER_TEST_ID = exports.SECURITY_SOLUTION_PAGE_WRAPPER_TEST_ID = 'alerts-page-security-solution-page-wrapper';

/**
 * Need a 100% height here to account for the graph/analyze tool, which sets no explicit height parameters, but fills the available space.
 */
const StyledFullHeightContainer = _styled.default.div`
  display: flex;
  flex-direction: column;
  flex: 1 1 auto;
`;
/**
 * Renders the content of the alerts page: search bar, header, filters, KPIs, and table sections.
 */
const AlertsPageContent = exports.AlertsPageContent = /*#__PURE__*/(0, _react.memo)(({
  dataView,
  oldSourcererDataViewSpec,
  runtimeMappings
}) => {
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const containerElement = (0, _react.useRef)(null);
  const {
    globalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const [assignees, setAssignees] = (0, _react.useState)([]);
  const [statusFilter, setStatusFilter] = (0, _react.useState)([]);
  const [pageFilters, setPageFilters] = (0, _react.useState)();
  const [pageFilterHandler, setPageFilterHandler] = (0, _react.useState)();
  const getTable = (0, _react.useMemo)(() => _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector(), []);
  const isTableLoading = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTable;
    return ((_getTable = getTable(state, _securitysolutionDataTable.TableId.alertsOnAlertsPage)) !== null && _getTable !== void 0 ? _getTable : _securitysolutionDataTable.tableDefaults).isLoading;
  });
  const onSkipFocusBeforeEventsTable = (0, _react.useCallback)(() => {
    (0, _helpers.focusUtilityBarAction)(containerElement.current);
  }, [containerElement]);
  const onSkipFocusAfterEventsTable = (0, _react.useCallback)(() => {
    (0, _helpers.resetKeyboardFocus)();
  }, []);
  const onKeyDown = (0, _react.useCallback)(keyboardEvent => {
    if ((0, _public.isTab)(keyboardEvent)) {
      (0, _helpers.onTimelineTabKeyPressed)({
        containerElement: containerElement.current,
        keyboardEvent,
        onSkipFocusBeforeEventsTable,
        onSkipFocusAfterEventsTable
      });
    }
  }, [containerElement, onSkipFocusBeforeEventsTable, onSkipFocusAfterEventsTable]);
  (0, _react.useEffect)(() => {
    if (!pageFilterHandler) return;
    // if Alert is reloaded because of action by the user.
    // We want reload the values in the detection Page filters
    if (!isTableLoading) pageFilterHandler.reload();
  }, [isTableLoading, pageFilterHandler]);
  return /*#__PURE__*/_react.default.createElement(StyledFullHeightContainer, {
    "data-test-subj": CONTENT_TEST_ID,
    onKeyDown: onKeyDown,
    ref: containerElement,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "resize",
    handler: _fp.noop,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_search_bar_section.SearchBarSection, {
    dataView: newDataViewPickerEnabled ? dataView : oldSourcererDataViewSpec,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    noPadding: globalFullScreen,
    "data-test-subj": SECURITY_SOLUTION_PAGE_WRAPPER_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_display.Display, {
    show: !globalFullScreen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: _translations.PAGE_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    assignees: assignees,
    setAssignees: setAssignees,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_filters_section.FiltersSection, {
    assignees: assignees,
    dataView: newDataViewPickerEnabled ? dataView : oldSourcererDataViewSpec,
    setStatusFilter: setStatusFilter,
    setPageFilters: setPageFilters,
    setPageFilterHandler: setPageFilterHandler,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_kpis_section.KPIsSection, {
    assignees: assignees,
    pageFilters: pageFilters,
    runtimeMappings: runtimeMappings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_table_section.TableSection, {
    assignees: assignees,
    dataView: dataView,
    dataViewSpec: oldSourcererDataViewSpec,
    pageFilters: pageFilters,
    statusFilter: statusFilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  })));
});
AlertsPageContent.displayName = 'AlertsPageContent';