"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseActionsList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _osquery_investigation_guide_panel = require("./osquery/osquery_investigation_guide_panel");
var _logic = require("../rule_management/logic");
var _response_action_type_form = require("./response_action_type_form");
var _shared_imports = require("../../shared_imports");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_response_actions/response_actions_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GhostFormField = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
const ResponseActionsList = exports.ResponseActionsList = /*#__PURE__*/_react.default.memo(({
  items,
  removeItem
}) => {
  const {
    detailName: ruleId
  } = (0, _reactRouterDom.useParams)();
  const {
    data: rule
  } = (0, _logic.useRule)(ruleId);
  const osqueryNoteQueries = (0, _react.useMemo)(() => rule !== null && rule !== void 0 && rule.note ? (0, _utils.getOsqueryQueriesFromNote)(rule.note) : [], [rule === null || rule === void 0 ? void 0 : rule.note]);
  const context = (0, _shared_imports.useFormContext)();
  const [formData] = (0, _shared_imports.useFormData)();
  const handleInvestigationGuideClick = (0, _react.useCallback)(() => {
    const values = (0, _utils.getResponseActionsFromNote)(osqueryNoteQueries, formData.responseActions);
    context.updateFieldValues(values);
  }, [context, formData === null || formData === void 0 ? void 0 : formData.responseActions, osqueryNoteQueries]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": 'response-actions-list',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, items.map((actionItem, index) => {
    return /*#__PURE__*/_react.default.createElement("div", {
      key: actionItem.id,
      "data-test-subj": `response-actions-list-item-${index}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_response_action_type_form.ResponseActionTypeForm, {
      item: actionItem,
      onDeleteAction: removeItem,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
      path: `${actionItem.path}.actionTypeId`,
      component: GhostFormField,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 13
      }
    }));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }), osqueryNoteQueries.length ? /*#__PURE__*/_react.default.createElement(_osquery_investigation_guide_panel.OsqueryInvestigationGuidePanel, {
    onClick: handleInvestigationGuideClick,
    queriesLength: osqueryNoteQueries.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }) : null);
});
ResponseActionsList.displayName = 'ResponseActionsList';