"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseActionFormField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _kibana = require("../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_response_actions/osquery/osquery_response_action_form_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ResponseActionFormField = exports.ResponseActionFormField = /*#__PURE__*/_react.default.memo(({
  field
}) => {
  const {
    clearErrors,
    value,
    setValue,
    path
  } = field;
  const {
    osquery
  } = (0, _kibana.useKibana)().services;
  const context = (0, _hook_form_lib.useFormContext)();
  const OsqueryForm = (0, _react.useMemo)(() => osquery === null || osquery === void 0 ? void 0 : osquery.OsqueryResponseActionTypeForm, [osquery === null || osquery === void 0 ? void 0 : osquery.OsqueryResponseActionTypeForm]);
  const handleError = (0, _react.useCallback)(newErrors => {
    if ((0, _lodash.isEmpty)(newErrors)) {
      clearErrors();
    } else {
      const errors = (0, _lodash.map)(newErrors, error => ({
        message: error.message
      }));
      context.setFieldErrors(path, errors);
    }
  }, [clearErrors, context, path]);

  // @ts-expect-error update types
  return /*#__PURE__*/_react.default.createElement(OsqueryForm, {
    defaultValues: value,
    onError: handleError,
    onChange: setValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 10
    }
  });
});
ResponseActionFormField.displayName = 'ResponseActionFormField';