"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCoverageOverviewDashboardContext = exports.initialState = exports.CoverageOverviewDashboardContextProvider = exports.CoverageOverviewDashboardContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _invariant = require("../../../../../common/utils/invariant");
var _detection_engine = require("../../../../../common/api/detection_engine");
var _coverage_overview_dashboard_reducer = require("./coverage_overview_dashboard_reducer");
var _use_fetch_coverage_overview_query = require("../../../rule_management/api/hooks/use_fetch_coverage_overview_query");
var _use_execute_bulk_action = require("../../../rule_management/logic/bulk_actions/use_execute_bulk_action");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/pages/coverage_overview/coverage_overview_dashboard_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CoverageOverviewDashboardContext = exports.CoverageOverviewDashboardContext = /*#__PURE__*/(0, _react.createContext)(null);
const initialState = exports.initialState = {
  showExpandedCells: false,
  filter: {
    activity: [_detection_engine.CoverageOverviewRuleActivity.Enabled],
    source: [_detection_engine.CoverageOverviewRuleSource.Prebuilt, _detection_engine.CoverageOverviewRuleSource.Custom]
  },
  data: undefined,
  isLoading: false
};
const CoverageOverviewDashboardContextProvider = ({
  children
}) => {
  const [state, dispatch] = (0, _react.useReducer)((0, _coverage_overview_dashboard_reducer.createCoverageOverviewDashboardReducer)(), initialState);
  const {
    data,
    isLoading,
    refetch
  } = (0, _use_fetch_coverage_overview_query.useFetchCoverageOverviewQuery)(state.filter);
  const {
    executeBulkAction
  } = (0, _use_execute_bulk_action.useExecuteBulkAction)();
  (0, _react.useEffect)(() => {
    refetch();
  }, [refetch, state.filter]);
  const setShowExpandedCells = (0, _react.useCallback)(value => {
    dispatch({
      type: _coverage_overview_dashboard_reducer.SET_SHOW_EXPANDED_CELLS,
      value
    });
  }, [dispatch]);
  const setRuleActivityFilter = (0, _react.useCallback)(value => {
    dispatch({
      type: _coverage_overview_dashboard_reducer.SET_RULE_ACTIVITY_FILTER,
      value
    });
  }, [dispatch]);
  const setRuleSourceFilter = (0, _react.useCallback)(value => {
    dispatch({
      type: _coverage_overview_dashboard_reducer.SET_RULE_SOURCE_FILTER,
      value
    });
  }, [dispatch]);
  const setRuleSearchFilter = (0, _react.useCallback)(value => {
    dispatch({
      type: _coverage_overview_dashboard_reducer.SET_RULE_SEARCH_FILTER,
      value
    });
  }, [dispatch]);
  const enableAllDisabled = (0, _react.useCallback)(async ruleIds => {
    await executeBulkAction({
      type: _detection_engine.BulkActionTypeEnum.enable,
      ids: ruleIds
    });
  }, [executeBulkAction]);
  const actions = (0, _react.useMemo)(() => ({
    refetch,
    setShowExpandedCells,
    setRuleActivityFilter,
    setRuleSourceFilter,
    setRuleSearchFilter,
    enableAllDisabled
  }), [refetch, setRuleActivityFilter, setRuleSearchFilter, setRuleSourceFilter, setShowExpandedCells, enableAllDisabled]);
  const providerValue = (0, _react.useMemo)(() => {
    return {
      state: {
        ...state,
        isLoading,
        data
      },
      actions
    };
  }, [actions, data, isLoading, state]);
  return /*#__PURE__*/_react.default.createElement(CoverageOverviewDashboardContext.Provider, {
    value: providerValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 5
    }
  }, children);
};
exports.CoverageOverviewDashboardContextProvider = CoverageOverviewDashboardContextProvider;
const useCoverageOverviewDashboardContext = () => {
  const dashboardContext = (0, _react.useContext)(CoverageOverviewDashboardContext);
  (0, _invariant.invariant)(dashboardContext, 'useCoverageOverviewDashboardContext should be used inside CoverageOverviewDashboardContextProvider');
  return dashboardContext;
};
exports.useCoverageOverviewDashboardContext = useCoverageOverviewDashboardContext;