"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRulesTableActions = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../../../common/detection_engine/rule_management/constants");
var _rule_management = require("../../../../../common/api/detection_engine/rule_management");
var _user_actions = require("../../../../common/lib/apm/user_actions");
var _use_start_transaction = require("../../../../common/lib/apm/use_start_transaction");
var _kibana = require("../../../../common/lib/kibana");
var _privileges = require("../../../../common/utils/privileges");
var i18n = _interopRequireWildcard(require("../../../common/translations"));
var _use_bulk_export = require("../../../rule_management/logic/bulk_actions/use_bulk_export");
var _use_execute_bulk_action = require("../../../rule_management/logic/bulk_actions/use_execute_bulk_action");
var _use_download_exported_rules = require("../../../rule_management/logic/bulk_actions/use_download_exported_rules");
var _use_has_actions_privileges = require("./use_has_actions_privileges");
var _use_schedule_rule_run = require("../../../rule_gaps/logic/use_schedule_rule_run");
var _telemetry = require("../../../../common/lib/telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/use_rules_table_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useRulesTableActions = ({
  showExceptionsDuplicateConfirmation,
  showManualRuleRunConfirmation,
  confirmDeletion
}) => {
  const {
    application: {
      navigateToApp
    },
    telemetry
  } = (0, _kibana.useKibana)().services;
  const hasActionsPrivileges = (0, _use_has_actions_privileges.useHasActionsPrivileges)();
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const {
    executeBulkAction
  } = (0, _use_execute_bulk_action.useExecuteBulkAction)();
  const {
    bulkExport
  } = (0, _use_bulk_export.useBulkExport)();
  const downloadExportedRules = (0, _use_download_exported_rules.useDownloadExportedRules)();
  const {
    scheduleRuleRun
  } = (0, _use_schedule_rule_run.useScheduleRuleRun)();
  return [{
    type: 'icon',
    'data-test-subj': 'editRuleAction',
    description: i18n.EDIT_RULE_SETTINGS,
    name: !hasActionsPrivileges ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "left",
      content: i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.EDIT_RULE_SETTINGS)) : i18n.EDIT_RULE_SETTINGS,
    icon: 'controlsHorizontal',
    onClick: rule => (0, _use_execute_bulk_action.goToRuleEditPage)(rule.id, navigateToApp),
    enabled: rule => (0, _privileges.canEditRuleWithActions)(rule, hasActionsPrivileges)
  }, {
    type: 'icon',
    'data-test-subj': 'duplicateRuleAction',
    description: i18n.DUPLICATE_RULE,
    icon: 'copy',
    name: !hasActionsPrivileges ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "left",
      content: i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.DUPLICATE_RULE)) : i18n.DUPLICATE_RULE,
    enabled: rule => (0, _privileges.canEditRuleWithActions)(rule, hasActionsPrivileges),
    // TODO extract those handlers to hooks, like useDuplicateRule
    onClick: async rule => {
      startTransaction({
        name: _user_actions.SINGLE_RULE_ACTIONS.DUPLICATE
      });
      const modalDuplicationConfirmationResult = await showExceptionsDuplicateConfirmation();
      if (modalDuplicationConfirmationResult === null) {
        return;
      }
      const result = await executeBulkAction({
        type: _rule_management.BulkActionTypeEnum.duplicate,
        ids: [rule.id],
        duplicatePayload: {
          include_exceptions: modalDuplicationConfirmationResult === _constants.DuplicateOptions.withExceptions || modalDuplicationConfirmationResult === _constants.DuplicateOptions.withExceptionsExcludeExpiredExceptions,
          include_expired_exceptions: !(modalDuplicationConfirmationResult === _constants.DuplicateOptions.withExceptionsExcludeExpiredExceptions)
        }
      });
      const createdRules = result === null || result === void 0 ? void 0 : result.attributes.results.created;
      if (createdRules !== null && createdRules !== void 0 && createdRules.length) {
        (0, _use_execute_bulk_action.goToRuleEditPage)(createdRules[0].id, navigateToApp);
      }
    }
  }, {
    type: 'icon',
    'data-test-subj': 'exportRuleAction',
    description: i18n.EXPORT_RULE,
    icon: 'exportAction',
    name: i18n.EXPORT_RULE,
    onClick: async rule => {
      startTransaction({
        name: _user_actions.SINGLE_RULE_ACTIONS.EXPORT
      });
      const response = await bulkExport({
        ids: [rule.id]
      });
      if (response) {
        await downloadExportedRules(response);
      }
    }
  }, {
    type: 'icon',
    'data-test-subj': 'manualRuleRunAction',
    description: rule => !rule.enabled ? i18n.MANUAL_RULE_RUN_TOOLTIP : i18n.MANUAL_RULE_RUN,
    icon: 'play',
    name: i18n.MANUAL_RULE_RUN,
    onClick: async rule => {
      startTransaction({
        name: _user_actions.SINGLE_RULE_ACTIONS.MANUAL_RULE_RUN
      });
      const modalManualRuleRunConfirmationResult = await showManualRuleRunConfirmation();
      telemetry.reportEvent(_telemetry.ManualRuleRunEventTypes.ManualRuleRunOpenModal, {
        type: 'single'
      });
      if (modalManualRuleRunConfirmationResult === null) {
        return;
      }
      await scheduleRuleRun({
        ruleIds: [rule.id],
        timeRange: modalManualRuleRunConfirmationResult
      });
    },
    enabled: rule => rule.enabled
  }, {
    type: 'icon',
    'data-test-subj': 'deleteRuleAction',
    description: i18n.DELETE_RULE,
    icon: 'trash',
    name: i18n.DELETE_RULE,
    onClick: async rule => {
      if ((await confirmDeletion()) === false) {
        // User has canceled deletion
        return;
      }
      startTransaction({
        name: _user_actions.SINGLE_RULE_ACTIONS.DELETE
      });
      await executeBulkAction({
        type: _rule_management.BulkActionTypeEnum.delete,
        ids: [rule.id]
      });
    }
  }];
};
exports.useRulesTableActions = useRulesTableActions;