"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesTableToolbar = exports.AllRulesTabs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _user_info = require("../../../../detections/components/user_info");
var _tab_navigation = require("../../../../common/components/navigation/tab_navigation");
var _use_prebuilt_rules_status = require("../../../rule_management/logic/prebuilt_rules/use_prebuilt_rules_status");
var _use_rule_management_filters = require("../../../rule_management/logic/use_rule_management_filters");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("../../../../assistant/helpers");
var _rules_table_context = require("./rules_table/rules_table_context");
var _use_assistant_availability = require("../../../../assistant/use_assistant_availability");
var i18nAssistant = _interopRequireWildcard(require("../../../common/translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/rules_table_toolbar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let AllRulesTabs = exports.AllRulesTabs = /*#__PURE__*/function (AllRulesTabs) {
  AllRulesTabs["management"] = "management";
  AllRulesTabs["monitoring"] = "monitoring";
  AllRulesTabs["updates"] = "updates";
  return AllRulesTabs;
}({});
const RulesTableToolbar = exports.RulesTableToolbar = /*#__PURE__*/_react.default.memo(() => {
  var _ruleManagementFilter, _ruleManagementFilter2, _prebuiltRulesStatus$;
  const {
    data: ruleManagementFilters
  } = (0, _use_rule_management_filters.useRuleManagementFilters)();
  const {
    data: prebuiltRulesStatus
  } = (0, _use_prebuilt_rules_status.usePrebuiltRulesStatus)();
  const [{
    loading,
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const installedTotal = ((_ruleManagementFilter = ruleManagementFilters === null || ruleManagementFilters === void 0 ? void 0 : ruleManagementFilters.rules_summary.custom_count) !== null && _ruleManagementFilter !== void 0 ? _ruleManagementFilter : 0) + ((_ruleManagementFilter2 = ruleManagementFilters === null || ruleManagementFilters === void 0 ? void 0 : ruleManagementFilters.rules_summary.prebuilt_installed_count) !== null && _ruleManagementFilter2 !== void 0 ? _ruleManagementFilter2 : 0);
  const updateTotal = (_prebuiltRulesStatus$ = prebuiltRulesStatus === null || prebuiltRulesStatus === void 0 ? void 0 : prebuiltRulesStatus.stats.num_prebuilt_rules_to_upgrade) !== null && _prebuiltRulesStatus$ !== void 0 ? _prebuiltRulesStatus$ : 0;
  const shouldDisplayRuleUpdatesTab = !loading && canUserCRUD && updateTotal > 0;
  const ruleTabs = (0, _react.useMemo)(() => ({
    [AllRulesTabs.management]: {
      id: AllRulesTabs.management,
      name: i18n.INSTALLED_RULES_TAB,
      disabled: false,
      href: `/rules/${AllRulesTabs.management}`,
      isBeta: installedTotal > 0,
      betaOptions: {
        text: `${installedTotal}`
      }
    },
    [AllRulesTabs.monitoring]: {
      id: AllRulesTabs.monitoring,
      name: i18n.RULE_MONITORING_TAB,
      disabled: false,
      href: `/rules/${AllRulesTabs.monitoring}`,
      isBeta: installedTotal > 0,
      betaOptions: {
        text: `${installedTotal}`
      }
    },
    ...(shouldDisplayRuleUpdatesTab ? {
      [AllRulesTabs.updates]: {
        id: AllRulesTabs.updates,
        name: i18n.RULE_UPDATES_TAB,
        disabled: false,
        href: `/rules/${AllRulesTabs.updates}`,
        isBeta: updateTotal > 0,
        betaOptions: {
          text: `${updateTotal}`
        }
      }
    } : {})
  }), [installedTotal, updateTotal, shouldDisplayRuleUpdatesTab]);

  // Assistant integration for using selected rules as prompt context
  const {
    hasAssistantPrivilege,
    isAssistantEnabled
  } = (0, _use_assistant_availability.useAssistantAvailability)();
  const {
    state: {
      rules,
      selectedRuleIds
    }
  } = (0, _rules_table_context.useRulesTableContext)();
  const selectedRules = (0, _react.useMemo)(() => rules.filter(rule => selectedRuleIds.includes(rule.id)), [rules, selectedRuleIds]);
  const selectedRuleNames = (0, _react.useMemo)(() => selectedRules.map(rule => rule.name), [selectedRules]);
  const getPromptContext = (0, _react.useCallback)(async () => (0, _helpers.getPromptContextFromDetectionRules)(selectedRules), [selectedRules]);
  const chatTitle = (0, _react.useMemo)(() => {
    return `${i18nAssistant.DETECTION_RULES_CONVERSATION_ID} - ${selectedRuleNames.join(', ')}`;
  }, [selectedRuleNames]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: 'spaceBetween',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_tab_navigation.TabNavigation, {
    navTabs: ruleTabs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }, hasAssistantPrivilege && selectedRules.length > 0 && isAssistantEnabled && /*#__PURE__*/_react.default.createElement(_elasticAssistant.NewChat, {
    category: "detection-rules",
    conversationTitle: chatTitle,
    description: i18nAssistant.RULE_MANAGEMENT_CONTEXT_DESCRIPTION,
    getPromptContext: getPromptContext,
    suggestedUserPrompt: i18nAssistant.EXPLAIN_THEN_SUMMARIZE_RULE_DETAILS,
    tooltip: i18nAssistant.RULE_MANAGEMENT_CONTEXT_TOOLTIP,
    isAssistantEnabled: isAssistantEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  })));
});
RulesTableToolbar.displayName = 'RulesTableToolbar';