"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkActions = void 0;
var _eui = require("@elastic/eui");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../../../common/lib/telemetry/events/bulk_fill_rule_gaps/types");
var _translations = require("./translations");
var _constants = require("../../../../../../common/constants");
var _kibana = require("../../../../../common/lib/kibana");
var _user_privileges = require("../../../../../common/components/user_privileges");
var _rule_filtering = require("../../../../../../common/detection_engine/rule_management/rule_filtering");
var _constants2 = require("../../../../../../common/detection_engine/rule_management/constants");
var _utils = require("../../../../rule_gaps/api/hooks/utils");
var _constants3 = require("../../../../rule_gaps/constants");
var _rule_management = require("../../../../../../common/api/detection_engine/rule_management");
var _helpers = require("../../../../../../common/machine_learning/helpers");
var _use_app_toasts = require("../../../../../common/hooks/use_app_toasts");
var _user_actions = require("../../../../../common/lib/apm/user_actions");
var _use_start_transaction = require("../../../../../common/lib/apm/use_start_transaction");
var _privileges = require("../../../../../common/utils/privileges");
var i18n = _interopRequireWildcard(require("../../../../common/translations"));
var _use_bulk_export = require("../../../../rule_management/logic/bulk_actions/use_bulk_export");
var _use_execute_bulk_action = require("../../../../rule_management/logic/bulk_actions/use_execute_bulk_action");
var _use_download_exported_rules = require("../../../../rule_management/logic/bulk_actions/use_download_exported_rules");
var _helpers2 = require("../helpers");
var _rules_table_context = require("../rules_table/rules_table_context");
var _use_has_actions_privileges = require("../use_has_actions_privileges");
var _use_has_ml_permissions = require("../use_has_ml_permissions");
var _compute_dry_run_edit_payload = require("./utils/compute_dry_run_edit_payload");
var _dry_run_result = require("./utils/dry_run_result");
var _prepare_search_params = require("./utils/prepare_search_params");
var _telemetry = require("../../../../../common/lib/telemetry");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _use_upselling = require("../../../../../common/hooks/use_upselling");
var _use_license = require("../../../../../common/hooks/use_license");
var _constants4 = require("../../../../../../common/detection_engine/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/bulk_actions/use_bulk_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable complexity */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useBulkActions = ({
  filterOptions,
  confirmDeletion,
  showBulkActionConfirmation,
  showBulkDuplicateConfirmation,
  showManualRuleRunConfirmation,
  showBulkFillRuleGapsConfirmation,
  showManualRuleRunLimitError,
  showBulkFillRuleGapsRuleLimitError,
  completeBulkEditForm,
  executeBulkActionsDryRun
}) => {
  const {
    services: startServices
  } = (0, _kibana.useKibana)();
  const hasMlPermissions = (0, _use_has_ml_permissions.useHasMlPermissions)();
  const rulesTableContext = (0, _rules_table_context.useRulesTableContext)();
  const hasActionsPrivileges = (0, _use_has_actions_privileges.useHasActionsPrivileges)();
  const toasts = (0, _use_app_toasts.useAppToasts)();
  const kql = (0, _rule_filtering.convertRulesFilterToKQL)(filterOptions);
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const {
    executeBulkAction
  } = (0, _use_execute_bulk_action.useExecuteBulkAction)();
  const {
    bulkExport
  } = (0, _use_bulk_export.useBulkExport)();
  const downloadExportedRules = (0, _use_download_exported_rules.useDownloadExportedRules)();
  const {
    timelinePrivileges: {
      crud: canCreateTimelines
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const {
    state: {
      isAllSelected,
      rules,
      loadingRuleIds,
      selectedRuleIds
    },
    actions: {
      clearRulesSelection,
      setIsPreflightInProgress
    }
  } = rulesTableContext;
  const globalQuery = (0, _react.useMemo)(() => {
    var _filterOptions$gapSea;
    const gapRange = filterOptions !== null && filterOptions !== void 0 && filterOptions.showRulesWithGaps ? (0, _utils.getGapRange)((_filterOptions$gapSea = filterOptions.gapSearchRange) !== null && _filterOptions$gapSea !== void 0 ? _filterOptions$gapSea : _constants3.defaultRangeValue) : undefined;
    return {
      query: kql,
      ...(gapRange && {
        gapRange
      })
    };
  }, [kql, filterOptions]);
  const isBulkEditAlertSuppressionFeatureEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('bulkEditAlertSuppressionEnabled');
  const isBulkFillRuleGapsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('bulkFillRuleGapsEnabled');
  const alertSuppressionUpsellingMessage = (0, _use_upselling.useUpsellingMessage)('alert_suppression_rule_form');
  const license = (0, _use_license.useLicense)();
  const isAlertSuppressionLicenseValid = license.isAtLeast(_constants4.MINIMUM_LICENSE_FOR_SUPPRESSION);
  const getBulkItemsPopoverContent = (0, _react.useCallback)(closePopover => {
    const selectedRules = rules.filter(({
      id
    }) => selectedRuleIds.includes(id));
    const containsEnabled = selectedRules.some(({
      enabled
    }) => enabled);
    const containsDisabled = selectedRules.some(({
      enabled
    }) => !enabled);
    const containsLoading = selectedRuleIds.some(id => loadingRuleIds.includes(id));
    const missingActionPrivileges = !hasActionsPrivileges && selectedRules.some(rule => !(0, _privileges.canEditRuleWithActions)(rule, hasActionsPrivileges));
    const handleEnableAction = async () => {
      startTransaction({
        name: _user_actions.BULK_RULE_ACTIONS.ENABLE
      });
      closePopover();
      const disabledRules = selectedRules.filter(({
        enabled
      }) => !enabled);
      const disabledRulesNoML = disabledRules.filter(({
        type
      }) => !(0, _helpers.isMlRule)(type));
      const mlRuleCount = disabledRules.length - disabledRulesNoML.length;
      if (!hasMlPermissions && mlRuleCount > 0) {
        toasts.addWarning((0, _translations.ML_RULES_UNAVAILABLE)(mlRuleCount));
      }
      const ruleIds = hasMlPermissions ? disabledRules.map(({
        id
      }) => id) : disabledRulesNoML.map(({
        id
      }) => id);
      await executeBulkAction({
        type: _rule_management.BulkActionTypeEnum.enable,
        ...(isAllSelected ? globalQuery : {
          ids: ruleIds
        })
      });
    };
    const handleDisableActions = async () => {
      startTransaction({
        name: _user_actions.BULK_RULE_ACTIONS.DISABLE
      });
      closePopover();
      const enabledIds = selectedRules.filter(({
        enabled
      }) => enabled).map(({
        id
      }) => id);
      await executeBulkAction({
        type: _rule_management.BulkActionTypeEnum.disable,
        ...(isAllSelected ? globalQuery : {
          ids: enabledIds
        })
      });
    };
    const handleDuplicateAction = async () => {
      startTransaction({
        name: _user_actions.BULK_RULE_ACTIONS.DUPLICATE
      });
      closePopover();
      const modalDuplicationConfirmationResult = await showBulkDuplicateConfirmation();
      if (modalDuplicationConfirmationResult === null) {
        return;
      }
      await executeBulkAction({
        type: _rule_management.BulkActionTypeEnum.duplicate,
        duplicatePayload: {
          include_exceptions: modalDuplicationConfirmationResult === _constants2.DuplicateOptions.withExceptions || modalDuplicationConfirmationResult === _constants2.DuplicateOptions.withExceptionsExcludeExpiredExceptions,
          include_expired_exceptions: !(modalDuplicationConfirmationResult === _constants2.DuplicateOptions.withExceptionsExcludeExpiredExceptions)
        },
        ...(isAllSelected ? globalQuery : {
          ids: selectedRuleIds
        })
      });
      clearRulesSelection();
    };
    const handleDeleteAction = async () => {
      closePopover();
      if ((await confirmDeletion()) === false) {
        // User has canceled deletion
        return;
      }
      startTransaction({
        name: _user_actions.BULK_RULE_ACTIONS.DELETE
      });
      await executeBulkAction({
        type: _rule_management.BulkActionTypeEnum.delete,
        ...(isAllSelected ? globalQuery : {
          ids: selectedRuleIds
        })
      });
    };
    const handleExportAction = async () => {
      closePopover();
      startTransaction({
        name: _user_actions.BULK_RULE_ACTIONS.EXPORT
      });
      const response = await bulkExport(isAllSelected ? globalQuery : {
        ids: selectedRuleIds
      });

      // if response null, likely network error happened and export rules haven't been received
      if (!response) {
        return;
      }
      const details = await (0, _helpers2.getExportedRulesDetails)(response);

      // if there are failed exported rules, show modal window to users.
      // they can either cancel action or proceed with export of succeeded rules
      const hasActionBeenConfirmed = await showBulkActionConfirmation((0, _dry_run_result.transformExportDetailsToDryRunResult)(details), _rule_management.BulkActionTypeEnum.export);
      if (hasActionBeenConfirmed === false) {
        return;
      }
      await downloadExportedRules(response);
    };
    const handleScheduleRuleRunAction = async () => {
      var _dryRunResult$succeed;
      startTransaction({
        name: _user_actions.BULK_RULE_ACTIONS.MANUAL_RULE_RUN
      });
      closePopover();
      setIsPreflightInProgress(true);
      const dryRunResult = await executeBulkActionsDryRun({
        type: _rule_management.BulkActionTypeEnum.run,
        ...(isAllSelected ? globalQuery : {
          ids: selectedRuleIds
        }),
        runPayload: {
          start_date: new Date(Date.now() - 1000).toISOString(),
          end_date: new Date().toISOString()
        }
      });
      setIsPreflightInProgress(false);
      if (((_dryRunResult$succeed = dryRunResult === null || dryRunResult === void 0 ? void 0 : dryRunResult.succeededRulesCount) !== null && _dryRunResult$succeed !== void 0 ? _dryRunResult$succeed : 0) > _constants.MAX_MANUAL_RULE_RUN_BULK_SIZE) {
        showManualRuleRunLimitError();
        return;
      }

      // User has cancelled edit action or there are no custom rules to proceed
      const hasActionBeenConfirmed = await showBulkActionConfirmation(dryRunResult, _rule_management.BulkActionTypeEnum.run);
      if (hasActionBeenConfirmed === false) {
        return;
      }
      const modalManualRuleRunConfirmationResult = await showManualRuleRunConfirmation();
      startServices.telemetry.reportEvent(_telemetry.ManualRuleRunEventTypes.ManualRuleRunOpenModal, {
        type: 'bulk'
      });
      if (modalManualRuleRunConfirmationResult === null) {
        return;
      }
      const enabledIds = selectedRules.filter(({
        enabled
      }) => enabled).map(({
        id
      }) => id);
      await executeBulkAction({
        type: _rule_management.BulkActionTypeEnum.run,
        ...(isAllSelected ? globalQuery : {
          ids: enabledIds
        }),
        runPayload: {
          start_date: modalManualRuleRunConfirmationResult.startDate.toISOString(),
          end_date: modalManualRuleRunConfirmationResult.endDate.toISOString()
        }
      });
      startServices.telemetry.reportEvent(_telemetry.ManualRuleRunEventTypes.ManualRuleRunExecute, {
        rangeInMs: modalManualRuleRunConfirmationResult.endDate.diff(modalManualRuleRunConfirmationResult.startDate),
        status: 'success',
        rulesCount: enabledIds.length
      });
    };
    const handleScheduleFillGapsAction = async () => {
      var _dryRunResult$succeed2;
      let longTimeWarningToast;
      let isBulkFillGapsFinished = false;
      startTransaction({
        name: _user_actions.BULK_RULE_ACTIONS.FILL_GAPS
      });
      closePopover();
      setIsPreflightInProgress(true);
      const dryRunResult = await executeBulkActionsDryRun({
        type: _rule_management.BulkActionTypeEnum.fill_gaps,
        ...(isAllSelected ? {
          query: (0, _rule_filtering.convertRulesFilterToKQL)(filterOptions)
        } : {
          ids: selectedRuleIds
        }),
        fillGapsPayload: {
          start_date: new Date(Date.now() - 1000).toISOString(),
          end_date: new Date().toISOString()
        }
      });
      setIsPreflightInProgress(false);
      if (((_dryRunResult$succeed2 = dryRunResult === null || dryRunResult === void 0 ? void 0 : dryRunResult.succeededRulesCount) !== null && _dryRunResult$succeed2 !== void 0 ? _dryRunResult$succeed2 : 0) > _constants.MAX_BULK_FILL_RULE_GAPS_BULK_SIZE) {
        showBulkFillRuleGapsRuleLimitError();
        return;
      }
      const hasActionBeenConfirmed = await showBulkActionConfirmation(dryRunResult, _rule_management.BulkActionTypeEnum.fill_gaps);
      if (hasActionBeenConfirmed === false) {
        return;
      }
      const modalBulkFillRuleGapsConfirmationResult = await showBulkFillRuleGapsConfirmation();
      startServices.telemetry.reportEvent(_types.BulkFillRuleGapsEventTypes.BulkFillRuleGapsOpenModal, {
        type: 'bulk'
      });
      if (modalBulkFillRuleGapsConfirmationResult === null) {
        return;
      }
      const enabledIds = selectedRules.filter(({
        enabled
      }) => enabled).map(({
        id
      }) => id);
      const hideWarningToast = () => {
        if (longTimeWarningToast) {
          toasts.api.remove(longTimeWarningToast);
        }
      };

      // show warning toast only if bulk fill gaps action exceeds 5s
      // if bulkAction already finished, we won't show toast at all (hence flag "isBulkFillGapsFinished")
      setTimeout(() => {
        var _dryRunResult$succeed3;
        if (isBulkFillGapsFinished) {
          return;
        }
        longTimeWarningToast = toasts.addWarning({
          title: i18n.BULK_FILL_RULE_GAPS_WARNING_TOAST_TITLE,
          text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 362,
              columnNumber: 19
            }
          }, i18n.BULK_FILL_RULE_GAPS_WARNING_TOAST_DESCRIPTION((_dryRunResult$succeed3 = dryRunResult === null || dryRunResult === void 0 ? void 0 : dryRunResult.succeededRulesCount) !== null && _dryRunResult$succeed3 !== void 0 ? _dryRunResult$succeed3 : 0)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            justifyContent: "flexEnd",
            gutterSize: "s",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 367,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 368,
              columnNumber: 21
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
            color: "warning",
            size: "s",
            onClick: hideWarningToast,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 369,
              columnNumber: 23
            }
          }, i18n.BULK_FILL_RULE_GAPS_WARNING_TOAST_NOTIFY)))), startServices),
          iconType: undefined
        }, {
          toastLifeTimeMs: 10 * 60 * 1000
        });
      }, 5 * 1000);
      await executeBulkAction({
        type: _rule_management.BulkActionTypeEnum.fill_gaps,
        ...(isAllSelected ? {
          query: kql
        } : {
          ids: enabledIds
        }),
        fillGapsPayload: {
          start_date: modalBulkFillRuleGapsConfirmationResult.startDate.toISOString(),
          end_date: modalBulkFillRuleGapsConfirmationResult.endDate.toISOString()
        }
      });
      isBulkFillGapsFinished = true;
      hideWarningToast();
      startServices.telemetry.reportEvent(_types.BulkFillRuleGapsEventTypes.BulkFillRuleGapsExecute, {
        rangeInMs: modalBulkFillRuleGapsConfirmationResult.endDate.diff(modalBulkFillRuleGapsConfirmationResult.startDate),
        status: 'success',
        rulesCount: enabledIds.length
      });
    };
    const handleBulkEdit = bulkEditActionType => async () => {
      let longTimeWarningToast;
      let isBulkEditFinished = false;
      closePopover();
      setIsPreflightInProgress(true);
      const dryRunResult = await executeBulkActionsDryRun({
        type: _rule_management.BulkActionTypeEnum.edit,
        ...(isAllSelected ? globalQuery : {
          ids: selectedRuleIds
        }),
        editPayload: (0, _compute_dry_run_edit_payload.computeDryRunEditPayload)(bulkEditActionType)
      });
      setIsPreflightInProgress(false);

      // User has cancelled edit action or there are no custom rules to proceed
      const hasActionBeenConfirmed = await showBulkActionConfirmation(dryRunResult, _rule_management.BulkActionTypeEnum.edit);
      if (hasActionBeenConfirmed === false) {
        return;
      }
      const editPayload = await completeBulkEditForm(bulkEditActionType);
      if (editPayload == null) {
        return;
      }
      startTransaction({
        name: _user_actions.BULK_RULE_ACTIONS.EDIT
      });
      const hideWarningToast = () => {
        if (longTimeWarningToast) {
          toasts.api.remove(longTimeWarningToast);
        }
      };

      // show warning toast only if bulk edit action exceeds 5s
      // if bulkAction already finished, we won't show toast at all (hence flag "isBulkEditFinished")
      setTimeout(() => {
        var _dryRunResult$succeed4;
        if (isBulkEditFinished) {
          return;
        }
        longTimeWarningToast = toasts.addWarning({
          title: i18n.BULK_EDIT_WARNING_TOAST_TITLE,
          text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 453,
              columnNumber: 19
            }
          }, i18n.BULK_EDIT_WARNING_TOAST_DESCRIPTION((_dryRunResult$succeed4 = dryRunResult === null || dryRunResult === void 0 ? void 0 : dryRunResult.succeededRulesCount) !== null && _dryRunResult$succeed4 !== void 0 ? _dryRunResult$succeed4 : 0)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            justifyContent: "flexEnd",
            gutterSize: "s",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 458,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 459,
              columnNumber: 21
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
            color: "warning",
            size: "s",
            onClick: hideWarningToast,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 460,
              columnNumber: 23
            }
          }, i18n.BULK_EDIT_WARNING_TOAST_NOTIFY)))), startServices),
          iconType: undefined
        }, {
          toastLifeTimeMs: 10 * 60 * 1000
        });
      }, 5 * 1000);
      await executeBulkAction({
        type: _rule_management.BulkActionTypeEnum.edit,
        ...(0, _prepare_search_params.prepareSearchParams)({
          ...(isAllSelected ? {
            filterOptions,
            gapRange: globalQuery.gapRange
          } : {
            selectedRuleIds
          }),
          dryRunResult
        }),
        editPayload: [editPayload]
      });
      hideWarningToast();
      isBulkEditFinished = true;
    };
    const isDeleteDisabled = containsLoading || selectedRuleIds.length === 0;
    const isEditDisabled = missingActionPrivileges || containsLoading || selectedRuleIds.length === 0;
    const isAlertSuppressionDisabled = isEditDisabled || !isAlertSuppressionLicenseValid;
    return [{
      id: 0,
      title: i18n.BULK_ACTION_MENU_TITLE,
      items: [{
        key: i18n.BULK_ACTION_ENABLE,
        name: i18n.BULK_ACTION_ENABLE,
        'data-test-subj': 'enableRuleBulk',
        disabled: missingActionPrivileges || containsLoading || !containsDisabled && !isAllSelected,
        onClick: handleEnableAction,
        toolTipContent: missingActionPrivileges ? i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES : undefined,
        toolTipProps: {
          position: 'right'
        },
        icon: undefined
      }, {
        key: i18n.BULK_ACTION_DUPLICATE,
        name: i18n.BULK_ACTION_DUPLICATE,
        'data-test-subj': 'duplicateRuleBulk',
        disabled: isEditDisabled,
        onClick: handleDuplicateAction,
        toolTipContent: missingActionPrivileges ? i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES : undefined,
        toolTipProps: {
          position: 'right'
        },
        icon: undefined
      }, {
        key: i18n.BULK_ACTION_INDEX_PATTERNS,
        name: i18n.BULK_ACTION_INDEX_PATTERNS,
        'data-test-subj': 'indexPatternsBulkEditRule',
        disabled: isEditDisabled,
        panel: 2
      }, {
        key: i18n.BULK_ACTION_TAGS,
        name: i18n.BULK_ACTION_TAGS,
        'data-test-subj': 'tagsBulkEditRule',
        disabled: isEditDisabled,
        panel: 1
      }, {
        key: i18n.BULK_ACTION_INVESTIGATION_FIELDS,
        name: i18n.BULK_ACTION_INVESTIGATION_FIELDS,
        'data-test-subj': 'investigationFieldsBulkEditRule',
        disabled: isEditDisabled,
        panel: 3
      }, ...(isBulkEditAlertSuppressionFeatureEnabled ? [{
        key: i18n.BULK_ACTION_ALERT_SUPPRESSION,
        name: i18n.BULK_ACTION_ALERT_SUPPRESSION,
        'data-test-subj': 'alertSuppressionBulkEditRule',
        disabled: isAlertSuppressionDisabled,
        toolTipContent: isAlertSuppressionLicenseValid ? undefined : alertSuppressionUpsellingMessage,
        panel: 4
      }] : []), {
        key: i18n.BULK_ACTION_ADD_RULE_ACTIONS,
        name: i18n.BULK_ACTION_ADD_RULE_ACTIONS,
        'data-test-subj': 'addRuleActionsBulk',
        disabled: !hasActionsPrivileges || isEditDisabled,
        onClick: handleBulkEdit(_rule_management.BulkActionEditTypeEnum.add_rule_actions),
        toolTipContent: !hasActionsPrivileges ? i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES : undefined,
        toolTipProps: {
          position: 'right'
        },
        icon: undefined
      }, {
        key: i18n.BULK_ACTION_SET_SCHEDULE,
        name: i18n.BULK_ACTION_SET_SCHEDULE,
        'data-test-subj': 'setScheduleBulk',
        disabled: isEditDisabled,
        onClick: handleBulkEdit(_rule_management.BulkActionEditTypeEnum.set_schedule),
        toolTipContent: missingActionPrivileges ? i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES : undefined,
        toolTipProps: {
          position: 'right'
        },
        icon: undefined
      }, {
        key: i18n.BULK_ACTION_APPLY_TIMELINE_TEMPLATE,
        name: i18n.BULK_ACTION_APPLY_TIMELINE_TEMPLATE,
        'data-test-subj': 'applyTimelineTemplateBulk',
        disabled: !canCreateTimelines || isEditDisabled,
        onClick: handleBulkEdit(_rule_management.BulkActionEditTypeEnum.set_timeline),
        toolTipContent: missingActionPrivileges ? i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES : undefined,
        toolTipProps: {
          position: 'right'
        },
        icon: undefined
      }, {
        key: i18n.BULK_ACTION_EXPORT,
        name: i18n.BULK_ACTION_EXPORT,
        'data-test-subj': 'exportRuleBulk',
        disabled: containsLoading || selectedRuleIds.length === 0,
        onClick: handleExportAction,
        icon: undefined
      }, {
        key: i18n.BULK_ACTION_MANUAL_RULE_RUN,
        name: i18n.BULK_ACTION_MANUAL_RULE_RUN,
        'data-test-subj': 'scheduleRuleRunBulk',
        disabled: containsLoading || !containsEnabled && !isAllSelected,
        onClick: handleScheduleRuleRunAction,
        icon: undefined
      }, ...(isBulkFillRuleGapsEnabled ? [{
        key: i18n.BULK_ACTION_FILL_RULE_GAPS,
        name: i18n.BULK_ACTION_FILL_RULE_GAPS,
        'data-test-subj': 'scheduleFillGaps',
        disabled: containsLoading || !containsEnabled && !isAllSelected,
        onClick: handleScheduleFillGapsAction,
        icon: undefined
      }] : []), {
        key: i18n.BULK_ACTION_DISABLE,
        name: i18n.BULK_ACTION_DISABLE,
        'data-test-subj': 'disableRuleBulk',
        disabled: missingActionPrivileges || containsLoading || !containsEnabled && !isAllSelected,
        onClick: handleDisableActions,
        toolTipContent: missingActionPrivileges ? i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES : undefined,
        toolTipProps: {
          position: 'right'
        },
        icon: undefined
      }, {
        key: i18n.BULK_ACTION_DELETE,
        name: isDeleteDisabled ? i18n.BULK_ACTION_DELETE : /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
          color: "danger",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 642,
            columnNumber: 17
          }
        }, i18n.BULK_ACTION_DELETE),
        'data-test-subj': 'deleteRuleBulk',
        disabled: isDeleteDisabled,
        onClick: handleDeleteAction,
        toolTipProps: {
          position: 'right'
        },
        icon: undefined
      }]
    }, {
      id: 1,
      title: i18n.BULK_ACTION_MENU_TITLE,
      items: [{
        key: i18n.BULK_ACTION_ADD_TAGS,
        name: i18n.BULK_ACTION_ADD_TAGS,
        'data-test-subj': 'addTagsBulkEditRule',
        onClick: handleBulkEdit(_rule_management.BulkActionEditTypeEnum.add_tags),
        disabled: isEditDisabled,
        toolTipContent: missingActionPrivileges ? i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES : undefined,
        toolTipProps: {
          position: 'right'
        }
      }, {
        key: i18n.BULK_ACTION_DELETE_TAGS,
        name: i18n.BULK_ACTION_DELETE_TAGS,
        'data-test-subj': 'deleteTagsBulkEditRule',
        onClick: handleBulkEdit(_rule_management.BulkActionEditTypeEnum.delete_tags),
        disabled: isEditDisabled,
        toolTipContent: missingActionPrivileges ? i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES : undefined,
        toolTipProps: {
          position: 'right'
        }
      }]
    }, {
      id: 2,
      title: i18n.BULK_ACTION_MENU_TITLE,
      items: [{
        key: i18n.BULK_ACTION_ADD_INDEX_PATTERNS,
        name: i18n.BULK_ACTION_ADD_INDEX_PATTERNS,
        'data-test-subj': 'addIndexPatternsBulkEditRule',
        onClick: handleBulkEdit(_rule_management.BulkActionEditTypeEnum.add_index_patterns),
        disabled: isEditDisabled,
        toolTipContent: missingActionPrivileges ? i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES : undefined,
        toolTipProps: {
          position: 'right'
        }
      }, {
        key: i18n.BULK_ACTION_DELETE_INDEX_PATTERNS,
        name: i18n.BULK_ACTION_DELETE_INDEX_PATTERNS,
        'data-test-subj': 'deleteIndexPatternsBulkEditRule',
        onClick: handleBulkEdit(_rule_management.BulkActionEditTypeEnum.delete_index_patterns),
        disabled: isEditDisabled,
        toolTipContent: missingActionPrivileges ? i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES : undefined,
        toolTipProps: {
          position: 'right'
        }
      }]
    }, {
      id: 3,
      title: i18n.BULK_ACTION_MENU_TITLE,
      items: [{
        key: i18n.BULK_ACTION_ADD_INVESTIGATION_FIELDS,
        name: i18n.BULK_ACTION_ADD_INVESTIGATION_FIELDS,
        'data-test-subj': 'addInvestigationFieldsBulkEditRule',
        onClick: handleBulkEdit(_rule_management.BulkActionEditTypeEnum.add_investigation_fields),
        disabled: isEditDisabled,
        toolTipContent: missingActionPrivileges ? i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES : undefined,
        toolTipProps: {
          position: 'right'
        }
      }, {
        key: i18n.BULK_ACTION_DELETE_INVESTIGATION_FIELDS,
        name: i18n.BULK_ACTION_DELETE_INVESTIGATION_FIELDS,
        'data-test-subj': 'deleteInvestigationFieldsBulkEditRule',
        onClick: handleBulkEdit(_rule_management.BulkActionEditTypeEnum.delete_investigation_fields),
        disabled: isEditDisabled,
        toolTipContent: missingActionPrivileges ? i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES : undefined,
        toolTipProps: {
          position: 'right'
        }
      }]
    }, {
      id: 4,
      title: i18n.BULK_ACTION_MENU_TITLE,
      items: [{
        key: i18n.BULK_ACTION_SET_ALERT_SUPPRESSION,
        name: i18n.BULK_ACTION_SET_ALERT_SUPPRESSION,
        'data-test-subj': 'setAlertSuppressionBulkEditRule',
        onClick: handleBulkEdit(_rule_management.BulkActionEditTypeEnum.set_alert_suppression),
        disabled: isAlertSuppressionDisabled,
        toolTipProps: {
          position: 'right'
        }
      }, {
        key: i18n.BULK_ACTION_SET_ALERT_SUPPRESSION_FOR_THRESHOLD,
        name: i18n.BULK_ACTION_SET_ALERT_SUPPRESSION_FOR_THRESHOLD,
        'data-test-subj': 'setAlertSuppressionForThresholdBulkEditRule',
        onClick: handleBulkEdit(_rule_management.BulkActionEditTypeEnum.set_alert_suppression_for_threshold),
        disabled: isAlertSuppressionDisabled,
        toolTipProps: {
          position: 'right'
        }
      }, {
        key: i18n.BULK_ACTION_DELETE_ALERT_SUPPRESSION,
        name: i18n.BULK_ACTION_DELETE_ALERT_SUPPRESSION,
        'data-test-subj': 'deleteAlertSuppressionBulkEditRule',
        onClick: handleBulkEdit(_rule_management.BulkActionEditTypeEnum.delete_alert_suppression),
        disabled: isAlertSuppressionDisabled,
        toolTipProps: {
          position: 'right'
        }
      }]
    }];
  }, [rules, selectedRuleIds, hasActionsPrivileges, isAllSelected, loadingRuleIds, startTransaction, hasMlPermissions, executeBulkAction, toasts, showBulkDuplicateConfirmation, showManualRuleRunConfirmation, showManualRuleRunLimitError, showBulkFillRuleGapsRuleLimitError, clearRulesSelection, confirmDeletion, bulkExport, showBulkActionConfirmation, downloadExportedRules, setIsPreflightInProgress, executeBulkActionsDryRun, filterOptions, completeBulkEditForm, isBulkEditAlertSuppressionFeatureEnabled, startServices, canCreateTimelines, isAlertSuppressionLicenseValid, alertSuppressionUpsellingMessage, globalQuery, kql, showBulkFillRuleGapsConfirmation, isBulkFillRuleGapsEnabled]);
  return getBulkItemsPopoverContent;
};
exports.useBulkActions = useBulkActions;