"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagsForm = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _use_rule_management_filters = require("../../../../../rule_management/logic/use_rule_management_filters");
var _rule_management = require("../../../../../../../common/api/detection_engine/rule_management");
var i18n = _interopRequireWildcard(require("../../../../../common/translations"));
var _helpers = require("../../helpers");
var _shared_imports = require("../../../../../../shared_imports");
var _bulk_edit_form_wrapper = require("./bulk_edit_form_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/bulk_actions/forms/tags_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CommonUseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const schema = {
  tags: {
    fieldsToValidateOnChange: ['tags'],
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    validations: [{
      validator: _shared_imports.fieldValidators.emptyField(i18n.BULK_EDIT_FLYOUT_FORM_TAGS_REQUIRED_ERROR)
    }]
  },
  overwrite: {
    type: _shared_imports.FIELD_TYPES.CHECKBOX,
    label: i18n.BULK_EDIT_FLYOUT_FORM_ADD_TAGS_OVERWRITE_LABEL
  }
};
const initialFormData = {
  tags: [],
  overwrite: false
};
const getFormConfig = editAction => editAction === _rule_management.BulkActionEditTypeEnum.add_tags ? {
  tagsLabel: i18n.BULK_EDIT_FLYOUT_FORM_ADD_TAGS_LABEL,
  tagsHelpText: i18n.BULK_EDIT_FLYOUT_FORM_ADD_TAGS_HELP_TEXT,
  formTitle: i18n.BULK_EDIT_FLYOUT_FORM_ADD_TAGS_TITLE
} : {
  tagsLabel: i18n.BULK_EDIT_FLYOUT_FORM_DELETE_TAGS_LABEL,
  tagsHelpText: i18n.BULK_EDIT_FLYOUT_FORM_DELETE_TAGS_HELP_TEXT,
  formTitle: i18n.BULK_EDIT_FLYOUT_FORM_DELETE_TAGS_TITLE
};
const TagsFormComponent = ({
  editAction,
  rulesCount,
  onClose,
  onConfirm
}) => {
  const {
    data: ruleManagementFilters
  } = (0, _use_rule_management_filters.useRuleManagementFilters)();
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: initialFormData,
    schema
  });
  const [{
    overwrite
  }] = (0, _shared_imports.useFormData)({
    form,
    watch: ['overwrite']
  });
  const sortedTags = (0, _react.useMemo)(() => {
    var _ruleManagementFilter;
    return (0, _helpers.caseInsensitiveSort)((_ruleManagementFilter = ruleManagementFilters === null || ruleManagementFilters === void 0 ? void 0 : ruleManagementFilters.aggregated_fields.tags) !== null && _ruleManagementFilter !== void 0 ? _ruleManagementFilter : []);
  }, [ruleManagementFilters]);
  const {
    tagsLabel,
    tagsHelpText,
    formTitle
  } = getFormConfig(editAction);
  const handleSubmit = async () => {
    const {
      data,
      isValid
    } = await form.submit();
    if (!isValid) {
      return;
    }
    onConfirm({
      value: data.tags,
      type: data.overwrite ? _rule_management.BulkActionEditTypeEnum.set_tags : editAction
    });
  };
  return /*#__PURE__*/_react.default.createElement(_bulk_edit_form_wrapper.BulkEditFormWrapper, {
    form: form,
    onClose: onClose,
    onSubmit: handleSubmit,
    title: formTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "tags",
    config: {
      ...schema.tags,
      label: tagsLabel,
      helpText: tagsHelpText
    },
    componentProps: {
      idAria: 'bulkEditRulesTags',
      'data-test-subj': 'bulkEditRulesTags',
      euiFieldProps: {
        fullWidth: true,
        placeholder: '',
        noSuggestions: false,
        options: sortedTags.map(label => ({
          label
        }))
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }), editAction === _rule_management.BulkActionEditTypeEnum.add_tags ? /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "overwrite",
    componentProps: {
      idAria: 'bulkEditRulesOverwriteTags',
      'data-test-subj': 'bulkEditRulesOverwriteTags'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }) : null, overwrite && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    size: "s",
    "data-test-subj": "bulkEditRulesTagsWarning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.setTagsWarningCallout",
    defaultMessage: "You\u2019re about to overwrite tags for {rulesCount, plural, one {# selected rule} other {# selected rules}}, press Save to apply changes.",
    values: {
      rulesCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 13
    }
  }))));
};
const TagsForm = exports.TagsForm = /*#__PURE__*/_react.default.memo(TagsFormComponent);
TagsForm.displayName = 'TagsForm';