"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationFieldsForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../../../../../common/lib/kibana");
var _constants = require("../../../../../../../common/constants");
var _telemetry = require("../../../../../../common/lib/telemetry");
var i18n = _interopRequireWildcard(require("../../../../../common/translations"));
var _source = require("../../../../../../common/containers/source");
var _rule_management = require("../../../../../../../common/api/detection_engine/rule_management");
var _shared_imports = require("../../../../../../shared_imports");
var _bulk_edit_form_wrapper = require("./bulk_edit_form_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/bulk_actions/forms/investigation_fields_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CommonUseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const schema = {
  investigationFields: {
    fieldsToValidateOnChange: ['investigationFields'],
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    validations: [{
      validator: _shared_imports.fieldValidators.emptyField(i18n.BULK_EDIT_FLYOUT_FORM_ADD_INVESTIGATION_FIELDS_REQUIRED_ERROR)
    }]
  },
  overwrite: {
    type: _shared_imports.FIELD_TYPES.CHECKBOX,
    label: i18n.BULK_EDIT_FLYOUT_FORM_ADD_INVESTIGATION_FIELDS_OVERWRITE_LABEL
  }
};
const initialFormData = {
  investigationFields: [],
  overwrite: false
};
const getFormConfig = editAction => editAction === _rule_management.BulkActionEditTypeEnum.add_investigation_fields ? {
  indexLabel: i18n.BULK_EDIT_FLYOUT_FORM_ADD_INVESTIGATION_FIELDS_LABEL,
  indexHelpText: i18n.BULK_EDIT_FLYOUT_FORM_ADD_INVESTIGATION_FIELDS_HELP_TEXT,
  formTitle: i18n.BULK_EDIT_FLYOUT_FORM_ADD_INVESTIGATION_FIELDS_TITLE
} : {
  indexLabel: i18n.BULK_EDIT_FLYOUT_FORM_DELETE_INVESTIGATION_FIELDS_LABEL,
  indexHelpText: i18n.BULK_EDIT_FLYOUT_FORM_DELETE_INVESTIGATION_FIELDS_HELP_TEXT,
  formTitle: i18n.BULK_EDIT_FLYOUT_FORM_DELETE_INVESTIGATION_FIELDS_TITLE
};
const InvestigationFieldsFormComponent = ({
  editAction,
  rulesCount,
  onClose,
  onConfirm
}) => {
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: initialFormData,
    schema
  });
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const defaultPatterns = uiSettings.get(_constants.DEFAULT_INDEX_KEY);
  const {
    indexHelpText,
    indexLabel,
    formTitle
  } = getFormConfig(editAction);
  const [{
    overwrite
  }] = (0, _shared_imports.useFormData)({
    form,
    watch: ['overwrite']
  });
  const [_, {
    indexPatterns
  }] = (0, _source.useFetchIndex)(defaultPatterns, false);
  const fieldOptions = indexPatterns.fields.map(field => ({
    label: field.name
  }));
  const handleSubmit = async () => {
    const {
      data,
      isValid
    } = await form.submit();
    if (!isValid) {
      return;
    }
    const event = data.overwrite ? _telemetry.TELEMETRY_EVENT.SET_INVESTIGATION_FIELDS : editAction === 'delete_investigation_fields' ? _telemetry.TELEMETRY_EVENT.DELETE_INVESTIGATION_FIELDS : _telemetry.TELEMETRY_EVENT.ADD_INVESTIGATION_FIELDS;
    (0, _telemetry.track)(_telemetry.METRIC_TYPE.CLICK, event);
    onConfirm({
      value: {
        field_names: data.investigationFields
      },
      type: data.overwrite ? _rule_management.BulkActionEditTypeEnum.set_investigation_fields : editAction
    });
  };
  return /*#__PURE__*/_react.default.createElement(_bulk_edit_form_wrapper.BulkEditFormWrapper, {
    form: form,
    onClose: onClose,
    onSubmit: handleSubmit,
    title: formTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "investigationFields",
    config: {
      ...schema.investigationFields,
      label: indexLabel,
      helpText: indexHelpText
    },
    componentProps: {
      idAria: 'bulkEditRulesInvestigationFields',
      'data-test-subj': 'bulkEditRulesInvestigationFields',
      euiFieldProps: {
        fullWidth: true,
        placeholder: '',
        noSuggestions: false,
        options: fieldOptions
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }), editAction === _rule_management.BulkActionEditTypeEnum.add_investigation_fields && /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "overwrite",
    componentProps: {
      idAria: 'bulkEditRulesOverwriteInvestigationFields',
      'data-test-subj': 'bulkEditRulesOverwriteInvestigationFields'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  }), overwrite && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    size: "s",
    "data-test-subj": "bulkEditRulesInvestigationFieldsWarning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.setInvestigationFieldsWarningCallout",
    defaultMessage: "You\u2019re about to overwrite custom highlighted fields for the {rulesCount, plural, one {# rule} other {# rules}} you selected. To apply and save the changes, click Save.",
    values: {
      rulesCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 13
    }
  }))));
};
const InvestigationFieldsForm = exports.InvestigationFieldsForm = /*#__PURE__*/_react.default.memo(InvestigationFieldsFormComponent);
InvestigationFieldsForm.displayName = 'InvestigationFieldsForm';