"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VersionsPicker = VersionsPicker;
exports.VersionsPickerOptionEnum = void 0;
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _utils = require("../utils");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/comparison_side/versions_picker/versions_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let VersionsPickerOptionEnum = exports.VersionsPickerOptionEnum = /*#__PURE__*/function (VersionsPickerOptionEnum) {
  VersionsPickerOptionEnum["MyChanges"] = "MY_CHANGES";
  VersionsPickerOptionEnum["MyOriginalChanges"] = "MY_ORIGINAL_CHANGES";
  VersionsPickerOptionEnum["UpdateFromElastic"] = "UPDATE_FROM_ELASTIC";
  VersionsPickerOptionEnum["Merged"] = "MERGED";
  return VersionsPickerOptionEnum;
}({});
function VersionsPicker({
  options,
  selectedOption,
  onChange
}) {
  const euiSelectOptions = options.map(option => {
    const {
      title: displayName,
      description: explanation
    } = (0, _utils.getOptionDetails)(option);
    return {
      value: option,
      text: displayName,
      title: explanation
    };
  });
  const handleChange = (0, _react.useCallback)(changeEvent => {
    onChange(changeEvent.target.value);
  }, [onChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    className: VERSIONS_PICKER_STYLES,
    options: euiSelectOptions,
    value: selectedOption,
    onChange: handleChange,
    "aria-label": i18n.VERSION_PICKER_ARIA_LABEL,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  });
}
const VERSIONS_PICKER_STYLES = (0, _css.css)`
  // Set min-width a bit wider than default
  // to make English text in narrow screens readable
  min-width: 300px;
`;