"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FillRuleGapsButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_bulk_fill_rule_gaps_confirmation = require("../bulk_fill_rule_gaps/use_bulk_fill_rule_gaps_confirmation");
var _bulk_fill_rule_gaps = require("../bulk_fill_rule_gaps");
var _use_execute_bulk_action = require("../../../rule_management/logic/bulk_actions/use_execute_bulk_action");
var _rule_management = require("../../../../../common/api/detection_engine/rule_management");
var _use_bulk_actions_dry_run = require("../../../rule_management_ui/components/rules_table/bulk_actions/use_bulk_actions_dry_run");
var _use_bulk_actions_confirmation = require("../../../rule_management_ui/components/rules_table/bulk_actions/use_bulk_actions_confirmation");
var _use_find_gaps_for_rule = require("../../api/hooks/use_find_gaps_for_rule");
var _use_find_backfills_for_rules = require("../../api/hooks/use_find_backfills_for_rules");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _kibana = require("../../../../common/lib/kibana");
var _use_start_transaction = require("../../../../common/lib/apm/use_start_transaction");
var _user_actions = require("../../../../common/lib/apm/user_actions");
var _types = require("../../../../common/lib/telemetry/events/bulk_fill_rule_gaps/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_gaps/components/rule_gaps/fill_rule_gaps_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ErrorMessage = ({
  errorCode,
  message
}) => {
  switch (errorCode) {
    case _rule_management.BulkActionsDryRunErrCodeEnum.RULE_FILL_GAPS_DISABLED_RULE:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 14
        }
      }, i18n.GAPS_FILL_ALL_GAPS_ERROR_DISABLED_RULE_MESSAGE);
    default:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 14
        }
      }, i18n.GAPS_FILL_ALL_GAPS_UNKNOWN_ERROR_MESSAGE(message));
  }
};
const FillRuleGapsButton = ({
  ruleId
}) => {
  var _bulkActionsDryRunRes;
  const {
    isBulkFillRuleGapsConfirmationVisible,
    showBulkFillRuleGapsConfirmation,
    cancelBulkFillRuleGaps,
    confirmBulkFillRuleGaps
  } = (0, _use_bulk_fill_rule_gaps_confirmation.useBulkFillRuleGapsConfirmation)();
  const {
    executeBulkAction
  } = (0, _use_execute_bulk_action.useExecuteBulkAction)();
  const {
    isBulkActionsDryRunLoading,
    executeBulkActionsDryRun
  } = (0, _use_bulk_actions_dry_run.useBulkActionsDryRun)();
  const {
    bulkActionsDryRunResult,
    bulkAction,
    isBulkActionConfirmationVisible,
    showBulkActionConfirmation,
    cancelBulkActionConfirmation
  } = (0, _use_bulk_actions_confirmation.useBulkActionsConfirmation)();
  const [isBulkActionExecuteLoading, setIsBulkActionExecuteLoading] = (0, _react.useState)(false);
  const invalidateFindGapsQuery = (0, _use_find_gaps_for_rule.useInvalidateFindGapsQuery)();
  const invalidateFindBackfillsQuery = (0, _use_find_backfills_for_rules.useInvalidateFindBackfillQuery)();
  const toasts = (0, _use_app_toasts.useAppToasts)();
  const {
    services: startServices
  } = (0, _kibana.useKibana)();
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const onFillGapsClick = (0, _react.useCallback)(async () => {
    if (isBulkActionsDryRunLoading || isBulkActionExecuteLoading) {
      return;
    }
    let longTimeWarningToast;
    let isBulkFillGapsFinished = false;
    startTransaction({
      name: _user_actions.BULK_RULE_ACTIONS.FILL_GAPS
    });
    setIsBulkActionExecuteLoading(true);
    const dryRunResult = await executeBulkActionsDryRun({
      type: _rule_management.BulkActionTypeEnum.fill_gaps,
      ids: [ruleId],
      fillGapsPayload: {
        start_date: new Date(Date.now() - 1000).toISOString(),
        end_date: new Date().toISOString()
      }
    });
    setIsBulkActionExecuteLoading(false);
    const hasActionBeenConfirmed = await showBulkActionConfirmation(dryRunResult, _rule_management.BulkActionTypeEnum.fill_gaps);
    if (hasActionBeenConfirmed === false) {
      return;
    }
    const modalBulkFillRuleGapsConfirmationResult = await showBulkFillRuleGapsConfirmation();
    startServices.telemetry.reportEvent(_types.BulkFillRuleGapsEventTypes.BulkFillRuleGapsOpenModal, {
      type: 'single'
    });
    if (modalBulkFillRuleGapsConfirmationResult === null) {
      return;
    }
    setIsBulkActionExecuteLoading(true);
    const hideWarningToast = () => {
      if (longTimeWarningToast) {
        toasts.api.remove(longTimeWarningToast);
      }
    };

    // show warning toast only if bulk fill gaps action exceeds 5s
    // if bulkAction already finished, we won't show toast at all (hence flag "isBulkFillGapsFinished")
    setTimeout(() => {
      if (isBulkFillGapsFinished) {
        return;
      }
      longTimeWarningToast = toasts.addWarning({
        title: i18n.GAPS_FILL_ALL_GAPS_WARNING_TOAST_TITLE,
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 139,
            columnNumber: 15
          }
        }, i18n.GAPS_FILL_ALL_GAPS_WARNING_TOAST_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          justifyContent: "flexEnd",
          gutterSize: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 140,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 141,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          color: "warning",
          size: "s",
          onClick: hideWarningToast,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 142,
            columnNumber: 19
          }
        }, i18n.GAPS_FILL_ALL_GAPS_WARNING_TOAST_NOTIFY)))), startServices),
        iconType: undefined
      }, {
        toastLifeTimeMs: 10 * 60 * 1000
      });
    }, 5 * 1000);
    const response = await executeBulkAction({
      type: _rule_management.BulkActionTypeEnum.fill_gaps,
      ids: [ruleId],
      fillGapsPayload: {
        start_date: modalBulkFillRuleGapsConfirmationResult.startDate.toISOString(),
        end_date: modalBulkFillRuleGapsConfirmationResult.endDate.toISOString()
      }
    });
    isBulkFillGapsFinished = true;
    hideWarningToast();
    setIsBulkActionExecuteLoading(false);
    invalidateFindGapsQuery();
    invalidateFindBackfillsQuery();
    startServices.telemetry.reportEvent(_types.BulkFillRuleGapsEventTypes.BulkFillRuleGapsExecute, {
      rangeInMs: modalBulkFillRuleGapsConfirmationResult.endDate.diff(modalBulkFillRuleGapsConfirmationResult.startDate),
      status: response !== undefined ? 'success' : 'error',
      rulesCount: 1
    });
  }, [isBulkActionsDryRunLoading, isBulkActionExecuteLoading, startServices, showBulkFillRuleGapsConfirmation, showBulkActionConfirmation, executeBulkAction, executeBulkActionsDryRun, invalidateFindBackfillsQuery, invalidateFindGapsQuery, ruleId, startTransaction, toasts]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isBulkFillRuleGapsConfirmationVisible && /*#__PURE__*/_react.default.createElement(_bulk_fill_rule_gaps.BulkFillRuleGapsModal, {
    onCancel: cancelBulkFillRuleGaps,
    onConfirm: confirmBulkFillRuleGaps,
    rulesCount: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 9
    }
  }), isBulkActionConfirmationVisible && bulkAction && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": confirmModalTitleId,
    title: i18n.GAPS_FILL_ALL_GAPS_DRY_RUN_MODAL_HEADING,
    titleProps: {
      id: confirmModalTitleId
    },
    onCancel: cancelBulkActionConfirmation,
    onConfirm: cancelBulkActionConfirmation,
    confirmButtonText: i18n.GAPS_FILL_ALL_GAPS_DRY_RUN_FAILED_MODAL_CLOSE_BUTTON_LABEL,
    defaultFocusedButton: "confirm",
    "data-test-subj": "bulkActionRejectModal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ErrorMessage, {
    errorCode: bulkActionsDryRunResult === null || bulkActionsDryRunResult === void 0 ? void 0 : bulkActionsDryRunResult.ruleErrors[0].errorCode,
    message: (_bulkActionsDryRunRes = bulkActionsDryRunResult === null || bulkActionsDryRunResult === void 0 ? void 0 : bulkActionsDryRunResult.ruleErrors[0].message) !== null && _bulkActionsDryRunRes !== void 0 ? _bulkActionsDryRunRes : '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "fill-rule-gaps-button",
    color: "primary",
    onClick: onFillGapsClick,
    "aria-label": i18n.GAPS_FILL_ALL_GAPS_BUTTON_LABEL,
    fill: true,
    isLoading: isBulkActionsDryRunLoading || isBulkActionExecuteLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 7
    }
  }, i18n.GAPS_FILL_ALL_GAPS_BUTTON_LABEL));
};
exports.FillRuleGapsButton = FillRuleGapsButton;