"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewHistogram = exports.ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _common = require("@kbn/data-plugin/common");
var _esQuery = require("@kbn/es-query");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _cell_value_context = require("../../../../detections/configurations/security_solution_detections/cell_value_context");
var _events_viewer = require("../../../../common/components/events_viewer");
var _renderers = require("../../../../timelines/components/timeline/body/renderers");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("./helpers");
var _panel = require("../../../../common/components/panel");
var _header_section = require("../../../../common/components/header_section");
var _default_config = require("../../../../detections/components/alerts_table/default_config");
var _model = require("../../../../sourcerer/store/model");
var _constants = require("../../../../../common/constants");
var _preview_table_cell_renderer = require("./preview_table_cell_renderer");
var _preview_table_control_columns = require("./preview_table_control_columns");
var _use_full_screen = require("../../../../common/containers/use_full_screen");
var _use_license = require("../../../../common/hooks/use_license");
var _kibana = require("../../../../common/lib/kibana");
var _rule_preview = require("../../../../common/components/visualization_actions/lens_attributes/common/alerts/rule_preview");
var _visualization_embeddable = require("../../../../common/components/visualization_actions/visualization_embeddable");
var _use_visualization_response = require("../../../../common/components/visualization_actions/use_visualization_response");
var _use_actions = require("../../../../common/components/visualization_actions/use_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/rule_preview/preview_histogram.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FullScreenContainer = _styledComponents.default.div`
  height: ${({
  $isFullScreen
}) => $isFullScreen ? '100%' : undefined};
  width: 100%;
`;
const ID = exports.ID = 'previewHistogram';
const CHART_HEIGHT = 150;
const DEFAULT_HISTOGRAM_HEIGHT = 300;
const PreviewHistogramComponent = ({
  previewId,
  addNoiseWarning,
  spaceId,
  ruleType,
  indexPattern,
  timeframeOptions
}) => {
  var _ref;
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const startDate = (0, _react.useMemo)(() => timeframeOptions.timeframeStart.toISOString(), [timeframeOptions]);
  const endDate = (0, _react.useMemo)(() => timeframeOptions.timeframeEnd.toISOString(), [timeframeOptions]);
  // It seems like the Table/Grid component uses end date value as a non-inclusive one,
  // thus the alerts which have timestamp equal to the end date value are not displayed in the table.
  // To fix that, we extend end date value by 1s to make sure all alerts are included in the table.
  const extendedEndDate = (0, _react.useMemo)(() => timeframeOptions.timeframeEnd.clone().add('1', 's').toISOString(), [timeframeOptions]);
  const isEqlRule = (0, _react.useMemo)(() => ruleType === 'eql', [ruleType]);
  const isMlRule = (0, _react.useMemo)(() => ruleType === 'machine_learning', [ruleType]);
  const timerange = (0, _react.useMemo)(() => ({
    from: startDate,
    to: endDate
  }), [startDate, endDate]);
  const extraVisualizationOptions = (0, _react.useMemo)(() => ({
    ruleId: previewId,
    spaceId,
    showLegend: !isEqlRule
  }), [isEqlRule, previewId, spaceId]);
  const license = (0, _use_license.useLicense)();
  const {
    globalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const previousPreviewId = (0, _usePrevious.default)(previewId);
  const previewQueryId = `${ID}-${previewId}`;
  const previewEmbeddableId = `${previewQueryId}-embeddable`;
  const {
    tables
  } = (0, _use_visualization_response.useVisualizationResponse)({
    visualizationId: previewEmbeddableId
  });
  const totalCount = (_ref = tables && tables.meta.statistics.totalCount) !== null && _ref !== void 0 ? _ref : 0;
  (0, _react.useEffect)(() => {
    if (previousPreviewId !== previewId && totalCount > 0) {
      if ((0, _helpers.isNoisy)(totalCount, timeframeOptions)) {
        addNoiseWarning();
      }
    }
  }, [addNoiseWarning, previewId, previousPreviewId, timeframeOptions, totalCount]);
  const config = (0, _common.getEsQueryConfig)(uiSettings);
  const pageFilters = (0, _react.useMemo)(() => {
    const filterQuery = (0, _esQuery.buildEsQuery)(indexPattern, [{
      query: `kibana.alert.rule.uuid:${previewId}`,
      language: 'kuery'
    }], [], {
      nestedIgnoreUnmapped: true,
      ...config,
      dateFormatTZ: undefined
    });
    return [{
      ...filterQuery,
      meta: {
        alias: null,
        negate: false,
        disabled: false,
        type: 'phrase',
        key: 'kibana.alert.rule.uuid',
        params: {
          query: previewId
        }
      }
    }];
  }, [config, indexPattern, previewId]);
  return /*#__PURE__*/_react.default.createElement(_cell_value_context.AlertTableCellContextProvider, {
    tableId: _securitysolutionDataTable.TableId.rulePreview,
    sourcererScope: _model.SourcererScopeName.detections,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_panel.Panel, {
    height: DEFAULT_HISTOGRAM_HEIGHT,
    "data-test-subj": 'preview-histogram-panel',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    id: previewQueryId,
    title: i18n.QUERY_GRAPH_HITS_TITLE,
    titleSize: "xs",
    showInspectButton: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    applyGlobalQueriesAndFilters: false,
    disableOnClickFilter: true,
    enableLegendActions: false,
    extraOptions: extraVisualizationOptions,
    getLensAttributes: _rule_preview.getRulePreviewLensAttributes,
    height: CHART_HEIGHT,
    id: previewEmbeddableId,
    inspectTitle: i18n.QUERY_GRAPH_HITS_TITLE,
    scopeId: _model.SourcererScopeName.detections,
    stackByField: ruleType === 'machine_learning' ? 'host.name' : 'event.category',
    timerange: timerange,
    withActions: _use_actions.INSPECT_ACTION,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 17
    }
  }, isMlRule ? i18n.ML_PREVIEW_HISTOGRAM_DISCLAIMER : i18n.PREVIEW_HISTOGRAM_DISCLAIMER)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(FullScreenContainer, {
    $isFullScreen: globalFullScreen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_events_viewer.StatefulEventsViewer, {
    pageFilters: pageFilters,
    defaultModel: (0, _default_config.getAlertsPreviewDefaultModel)(license),
    end: extendedEndDate,
    tableId: _securitysolutionDataTable.TableId.rulePreview,
    leadingControlColumns: (0, _preview_table_control_columns.getPreviewTableControlColumn)(1.5),
    renderCellValue: _preview_table_cell_renderer.PreviewRenderCellValue,
    rowRenderers: _renderers.defaultRowRenderers,
    start: startDate,
    sourcererScope: _model.SourcererScopeName.detections,
    indexNames: [`${_constants.DEFAULT_PREVIEW_INDEX}-${spaceId}`],
    bulkActions: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 9
    }
  })));
};
const PreviewHistogram = exports.PreviewHistogram = /*#__PURE__*/_react.default.memo(PreviewHistogramComponent);
PreviewHistogram.displayName = 'PreviewHistogram';