"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SYSTEM_ACTION_FREQUENCY = exports.SUMMARY_OF_ALERTS_PER_RULE_RUN = exports.RULE_SNOOZE_DESCRIPTION = exports.RESPONSE_ACTIONS = exports.PERIODICALLY = exports.NO_ACTIONS_READ_PERMISSIONS = exports.NOTIFICATION_ACTIONS = exports.FOR_EACH_ALERT_PER_RULE_RUN = exports.ACTIONS = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _kibana = require("../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/step_rule_actions/translations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NO_ACTIONS_READ_PERMISSIONS = exports.NO_ACTIONS_READ_PERMISSIONS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepRuleActions.noReadActionsPrivileges', {
  defaultMessage: 'Cannot create rule actions. You do not have "Read" permissions for the "Actions" plugin.'
});
const RULE_SNOOZE_DOCS_LINK_TEXT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepRuleActions.docsLinkText', {
  defaultMessage: 'Learn more'
});
function RuleSnoozeDescription() {
  const {
    docLinks: {
      links: {
        securitySolution: {
          manageDetectionRules
        }
      }
    }
  } = (0, _kibana.useKibana)().services;
  const manageDetectionRulesSnoozeSection = `${manageDetectionRules}#edit-rules-settings`;
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.createRule.stepRuleActions.snoozeDescription",
    defaultMessage: "Choose when to perform actions or snooze them. Notifications are not created for snoozed actions. {docs}.",
    values: {
      docs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: manageDetectionRulesSnoozeSection,
        target: "_blank",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 45,
          columnNumber: 11
        }
      }, RULE_SNOOZE_DOCS_LINK_TEXT)
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  });
}
const RULE_SNOOZE_DESCRIPTION = exports.RULE_SNOOZE_DESCRIPTION = /*#__PURE__*/_react.default.createElement(RuleSnoozeDescription, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 54,
    columnNumber: 40
  }
});
const ACTIONS = exports.ACTIONS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.actionsSectionLabel', {
  defaultMessage: 'Actions'
});
const NOTIFICATION_ACTIONS = exports.NOTIFICATION_ACTIONS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.notificationActions', {
  defaultMessage: 'Notification actions'
});
const RESPONSE_ACTIONS = exports.RESPONSE_ACTIONS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.responseActions', {
  defaultMessage: 'Response actions'
});
const FOR_EACH_ALERT_PER_RULE_RUN = exports.FOR_EACH_ALERT_PER_RULE_RUN = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.actionNotifyWhen.forEachOption', {
  defaultMessage: 'For each alert. Per rule run.'
});
const SUMMARY_OF_ALERTS_PER_RULE_RUN = exports.SUMMARY_OF_ALERTS_PER_RULE_RUN = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.actionNotifyWhen.summaryOption', {
  defaultMessage: 'Summary of alerts. Per rule run.'
});
const PERIODICALLY = exports.PERIODICALLY = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.actionNotifyWhen.periodically', {
  defaultMessage: 'Periodically'
});
const SYSTEM_ACTION_FREQUENCY = exports.SYSTEM_ACTION_FREQUENCY = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.actionNotifyWhen.systemActionFrequency', {
  defaultMessage: 'On check intervals'
});