"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EqlQueryEdit = EqlQueryEdit;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _shared_imports = require("../../../../shared_imports");
var _query_required_validator_factory = require("../../../rule_creation_ui/validators/query_required_validator_factory");
var _eql_query_validator_factory = require("./validators/eql_query_validator_factory");
var _eql_query_bar = require("./eql_query_bar");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/eql_query_edit/eql_query_edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function EqlQueryEdit({
  path,
  eqlOptionsPath,
  fieldsToValidateOnChange,
  showEqlSizeOption = false,
  showFilterBar = false,
  dataView,
  required,
  loading,
  disabled,
  onValidityChange
}) {
  const componentProps = (0, _react.useMemo)(() => ({
    isSizeOptionDisabled: !showEqlSizeOption,
    isDisabled: disabled,
    isLoading: loading,
    indexPattern: dataView,
    showFilterBar,
    idAria: 'ruleEqlQueryBar',
    dataTestSubj: 'ruleEqlQueryBar',
    onValidityChange
  }), [showEqlSizeOption, showFilterBar, onValidityChange, dataView, loading, disabled]);
  const fieldConfig = (0, _react.useMemo)(() => ({
    label: i18n.EQL_QUERY_BAR_LABEL,
    fieldsToValidateOnChange: fieldsToValidateOnChange ? [path, fieldsToValidateOnChange].flat() : undefined,
    validations: [...(required ? [{
      validator: (0, _query_required_validator_factory.queryRequiredValidatorFactory)('eql')
    }] : []), {
      validator: (0, _securitysolutionUtils.debounceAsync)(data => {
        const {
          formData
        } = data;
        const eqlOptions = eqlOptionsPath && formData[eqlOptionsPath] ? formData[eqlOptionsPath] : {};
        return (0, _eql_query_validator_factory.eqlQueryValidatorFactory)(dataView.id ? {
          dataViewId: dataView.id,
          eqlOptions
        } : {
          indexPatterns: dataView.title.split(','),
          eqlOptions
        })(data);
      }, 300),
      isAsync: true
    }]
  }), [eqlOptionsPath, required, dataView.id, dataView.title, path, fieldsToValidateOnChange]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseMultiFields, {
    fields: {
      eqlQuery: {
        path,
        config: fieldConfig
      },
      eqlOptions: {
        path: eqlOptionsPath
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  }, ({
    eqlQuery,
    eqlOptions
  }) => /*#__PURE__*/_react.default.createElement(_eql_query_bar.EqlQueryBar, (0, _extends2.default)({
    field: eqlQuery,
    eqlOptionsField: eqlOptions
  }, componentProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  })));
}