"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.track = exports.initTelemetry = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const noop = () => {};
let _track;
const track = (type, event, count) => {
  try {
    _track(type, event, count);
  } catch (error) {
    // ignore failed tracking call
  }
};
exports.track = track;
const initTelemetry = ({
  usageCollection
}, appId) => {
  var _usageCollection$repo, _usageCollection$repo2;
  _track = (_usageCollection$repo = usageCollection === null || usageCollection === void 0 ? void 0 : (_usageCollection$repo2 = usageCollection.reportUiCounter) === null || _usageCollection$repo2 === void 0 ? void 0 : _usageCollection$repo2.bind(null, appId)) !== null && _usageCollection$repo !== void 0 ? _usageCollection$repo : noop;
};
exports.initTelemetry = initTelemetry;