"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIntegrationCardGridTabsStyles = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIntegrationCardGridTabsStyles = () => {
  const {
    euiTheme,
    colorMode
  } = (0, _eui.useEuiTheme)();
  if (colorMode !== _eui.COLOR_MODES_STANDARD.dark) {
    return undefined;
  }
  // only apply styles in dark mode
  return (0, _react.css)`
    button {
      position: relative;
    }
    button:not(:first-child)::before {
      position: absolute;
      left: 0px;
      content: ' ';
      width: 1px;
      height: 70%;
      background-color: ${euiTheme.colors.darkShade};
      top: 50%;
      transform: translateY(-50%);
    }
    button[aria-pressed='true'],
    button[aria-pressed='true'] + button {
      &::before {
        content: none;
      }
    }
    button[aria-pressed='true'] {
      text-decoration: none;
    }
  `;
};
exports.useIntegrationCardGridTabsStyles = useIntegrationCardGridTabsStyles;