"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRowItemsWithActions = exports.RowItemOverflowComponent = exports.RowItemOverflow = exports.Popover = exports.OverflowFieldComponent = exports.OverflowField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _cell_actions = require("../cell_actions");
var _helpers = require("../drag_and_drop/helpers");
var _empty_value = require("../empty_value");
var _page = require("../page");
var _more_container = require("../../../timelines/components/field_renderers/more_container");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/tables/helpers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getRowItemsWithActions = ({
  values,
  fieldName,
  idPrefix,
  render,
  displayCount = 5,
  maxOverflow = 5
}) => {
  if (values != null && values.length > 0) {
    const visibleItems = values.slice(0, displayCount).map((value, index) => {
      const id = (0, _helpers.escapeDataProviderId)(`${idPrefix}-${fieldName}-${value}-${index}`);
      return /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
        key: id,
        mode: _cell_actions.CellActionsMode.HOVER_DOWN,
        visibleCellActions: 5,
        showActionTooltips: true,
        triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
        data: {
          value,
          field: fieldName
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, render ? render(value) : (0, _empty_value.defaultToEmptyTag)(value)));
    });
    return visibleItems.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, visibleItems, ' ', /*#__PURE__*/_react.default.createElement(RowItemOverflow, {
      fieldName: fieldName,
      values: values,
      idPrefix: idPrefix,
      overflowIndexStart: displayCount,
      maxOverflowItems: maxOverflow,
      render: render,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 9
      }
    })) : (0, _empty_value.getEmptyTagValue)();
  } else {
    return (0, _empty_value.getEmptyTagValue)();
  }
};
exports.getRowItemsWithActions = getRowItemsWithActions;
const RowItemOverflowComponent = ({
  fieldName,
  values,
  idPrefix,
  overflowIndexStart = 5,
  maxOverflowItems = 5,
  render
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const maxVisibleValues = (0, _react.useMemo)(() => values.slice(0, maxOverflowItems + 1), [values, maxOverflowItems]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, values.length > overflowIndexStart && /*#__PURE__*/_react.default.createElement(Popover, {
    count: values.length - overflowIndexStart,
    idPrefix: idPrefix,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_more_container.MoreContainer, {
    fieldName: fieldName,
    idPrefix: idPrefix,
    values: maxVisibleValues,
    overflowIndexStart: overflowIndexStart,
    moreMaxHeight: "none",
    render: render,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 13
    }
  })), values.length > overflowIndexStart + maxOverflowItems && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: {
      paddingTop: euiTheme.size.m
    },
    "data-test-subj": "popover-additional-overflow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 19
    }
  }, values.length - overflowIndexStart - maxOverflowItems, ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    "data-test-subj": "popover-additional-overflow-text",
    id: "xpack.securitySolution.tables.rowItemHelper.moreDescription",
    defaultMessage: "more not shown",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 21
    }
  })))))));
};
exports.RowItemOverflowComponent = RowItemOverflowComponent;
RowItemOverflowComponent.displayName = 'RowItemOverflowComponent';
const RowItemOverflow = exports.RowItemOverflow = /*#__PURE__*/_react.default.memo(RowItemOverflowComponent);
const useStyles = () => {
  return {
    subtext: (0, _react2.css)`
      font-size: ${(0, _eui.useEuiFontSize)('xs').fontSize};
    `
  };
};
const PopoverComponent = ({
  children,
  count,
  idPrefix
}) => {
  const styles = useStyles();
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => {
    setIsOpen(!isOpen);
  }, [isOpen]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.subtext,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: onButtonClick,
      "data-test-subj": "overflow-button",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.tables.rowItemHelper.overflowButtonDescription",
      defaultMessage: "+{count} More",
      values: {
        count
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 13
      }
    })),
    closePopover: () => setIsOpen(!isOpen),
    id: `${idPrefix}-popover`,
    isOpen: isOpen,
    panelClassName: "withHoverActions__popover",
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 7
    }
  }, children));
};
PopoverComponent.displayName = 'PopoverComponent';
const Popover = exports.Popover = /*#__PURE__*/_react.default.memo(PopoverComponent);
Popover.displayName = 'Popover';
const OverflowFieldComponent = ({
  value,
  showToolTip = true,
  overflowLength = 50
}) => /*#__PURE__*/_react.default.createElement("span", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 207,
    columnNumber: 3
  }
}, showToolTip ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  "data-test-subj": 'message-tooltip',
  content: 'message',
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 209,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement("span", {
  tabIndex: 0,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 210,
    columnNumber: 9
  }
}, value.substring(0, overflowLength))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value.substring(0, overflowLength)), value.length > overflowLength && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: value,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 216,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_page.MoreRowItems, {
  type: "boxesHorizontal",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 217,
    columnNumber: 9
  }
})));
exports.OverflowFieldComponent = OverflowFieldComponent;
OverflowFieldComponent.displayName = 'OverflowFieldComponent';
const OverflowField = exports.OverflowField = /*#__PURE__*/_react.default.memo(OverflowFieldComponent);
OverflowField.displayName = 'OverflowField';