"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleActionsField = void 0;
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _deepmerge = _interopRequireDefault(require("deepmerge"));
var _reactMarkdown = _interopRequireDefault(require("react-markdown"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _common = require("@kbn/actions-plugin/common");
var _i18nReact = require("@kbn/i18n-react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _constants = require("../../../../common/constants");
var _shared_imports = require("../../../shared_imports");
var _kibana = require("../../lib/kibana");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/rule_actions_field/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NOTIFY_WHEN_OPTIONS = [{
  isSummaryOption: true,
  isForEachAlertOption: true,
  value: {
    value: 'onActiveAlert',
    inputDisplay: _translations.FORM_ON_ACTIVE_ALERT_OPTION,
    'data-test-subj': 'onActiveAlert',
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Per rule run",
      id: "xpack.securitySolution.detectionEngine.ruleNotifyWhen.onActiveAlert.label",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 13
      }
    })))
  }
}, {
  isSummaryOption: true,
  isForEachAlertOption: false,
  value: {
    value: 'onThrottleInterval',
    inputDisplay: _translations.FORM_CUSTOM_FREQUENCY_OPTION,
    'data-test-subj': 'onThrottleInterval',
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Custom frequency",
      id: "xpack.securitySolution.detectionEngine.ruleNotifyWhen.onThrottleInterval.label",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 13
      }
    })))
  }
}];
const DEFAULT_ACTION_GROUP_ID = 'default';
const FieldErrorsContainer = _styledComponents.default.div`
  p {
    margin-bottom: 0;
  }
`;
const ContainerActions = _styledComponents.default.div.attrs(({
  className = '',
  $caseIndexes = []
}) => ({
  className
}))`
  ${({
  $caseIndexes
}) => $caseIndexes.map(index => `
        div[id="${index}"].euiAccordion__childWrapper .euiAccordion__children {
          padding: 0px;
          .euiFlexGroup {
            display: none;
          }
          .euiSpacer.euiSpacer--xl {
            height: 0px;
          }
        }
      `)}
`;
const RuleActionsField = ({
  ruleTypeId,
  field,
  messageVariables,
  summaryMessageVariables,
  defaultRuleFrequency = _constants.NOTIFICATION_DEFAULT_FREQUENCY,
  minimumThrottleInterval
}) => {
  const [fieldErrors, setFieldErrors] = (0, _react.useState)(null);
  const form = (0, _shared_imports.useFormContext)();
  const {
    isValid
  } = form;
  const {
    triggersActionsUi: {
      getActionForm
    }
  } = (0, _kibana.useKibana)().services;

  // Workaround for setAlertActionsProperty being fired with prevProps when followed by setActionIdByIndex
  // For details see: https://github.com/elastic/kibana/issues/142217
  const [isInitializingAction, setIsInitializingAction] = (0, _react.useState)(false);
  const actions = (0, _react.useMemo)(() => !(0, _fp.isEmpty)(field.value) ? field.value : [], [field.value]);
  const caseActionIndexes = (0, _react.useMemo)(() => actions.reduce((acc, action, actionIndex) => {
    if (action.actionTypeId === '.case') {
      return [...acc, `${actionIndex}`];
    }
    return acc;
  }, []), [actions]);
  const setActionIdByIndex = (0, _react.useCallback)((id, index) => {
    const updatedActions = [...actions];
    if ((0, _fp.isEmpty)(updatedActions[index].params)) {
      setIsInitializingAction(true);
    }
    updatedActions[index] = (0, _deepmerge.default)(updatedActions[index], {
      id
    });
    field.setValue(updatedActions);
  }, [field, actions]);
  const setAlertActionsProperty = (0, _react.useCallback)(updatedActions => field.setValue(updatedActions), [field]);
  const setActionParamsProperty = (0, _react.useCallback)((key, value, index) => {
    // validation is not triggered correctly when actions params updated (more details in https://github.com/elastic/kibana/issues/142217)
    // wrapping field.setValue in setTimeout fixes the issue above
    // and triggers validation after params have been updated, however it introduced a new issue where any additional input
    // would result in the cursor jumping to the end of the text area (https://github.com/elastic/kibana/issues/149885)
    const updateValue = () => {
      field.setValue(prevValue => {
        const updatedActions = [...prevValue];
        updatedActions[index] = {
          ...updatedActions[index],
          params: {
            ...updatedActions[index].params,
            [key]: value
          }
        };
        return updatedActions;
      });
    };
    if (isInitializingAction) {
      setTimeout(updateValue, 0);
      setIsInitializingAction(false);
    } else {
      updateValue();
    }
  }, [field, isInitializingAction]);
  const setActionAlertsFilterProperty = (0, _react.useCallback)((key, value, index) => {
    field.setValue(prevValue => {
      const updatedActions = [...prevValue];
      const {
        alertsFilter,
        ...rest
      } = updatedActions[index];
      const updatedAlertsFilter = {
        ...alertsFilter
      };
      if (value) {
        updatedAlertsFilter[key] = value;
      } else {
        delete updatedAlertsFilter[key];
      }
      updatedActions[index] = {
        ...rest,
        ...(!(0, _fp.isEmpty)(updatedAlertsFilter) ? {
          alertsFilter: updatedAlertsFilter
        } : {})
      };
      return updatedActions;
    });
  }, [field]);
  const setActionFrequency = (0, _react.useCallback)((key, value, index) => {
    field.setValue(prevValue => {
      var _updatedActions$index;
      const updatedActions = [...prevValue];
      updatedActions[index] = {
        ...updatedActions[index],
        frequency: {
          ...((_updatedActions$index = updatedActions[index].frequency) !== null && _updatedActions$index !== void 0 ? _updatedActions$index : defaultRuleFrequency),
          [key]: value
        }
      };
      return updatedActions;
    });
  }, [defaultRuleFrequency, field]);
  const isFormValidated = isValid !== undefined;
  const actionForm = (0, _react.useMemo)(() => getActionForm({
    actions,
    messageVariables,
    summaryMessageVariables,
    defaultActionGroupId: DEFAULT_ACTION_GROUP_ID,
    setActionIdByIndex,
    setActions: setAlertActionsProperty,
    setActionParamsProperty,
    setActionFrequencyProperty: setActionFrequency,
    setActionAlertsFilterProperty,
    featureId: _common.SecurityConnectorFeatureId,
    producerId: _ruleDataUtils.AlertConsumers.SIEM,
    ruleTypeId,
    defaultActionMessage: _translations.FORM_FOR_EACH_ALERT_BODY_MESSAGE,
    defaultSummaryMessage: _translations.FORM_SUMMARY_BODY_MESSAGE,
    hideActionHeader: true,
    hasAlertsMappings: true,
    notifyWhenSelectOptions: NOTIFY_WHEN_OPTIONS,
    defaultRuleFrequency,
    disableErrorMessages: !isFormValidated,
    minimumThrottleInterval
  }), [getActionForm, actions, messageVariables, summaryMessageVariables, setActionIdByIndex, setAlertActionsProperty, setActionParamsProperty, setActionFrequency, setActionAlertsFilterProperty, ruleTypeId, defaultRuleFrequency, isFormValidated, minimumThrottleInterval]);
  (0, _react.useEffect)(() => {
    if (isValid === false) {
      const errorsString = field.errors.map(({
        message
      }) => message).join('\n');
      return setFieldErrors(errorsString);
    }
    return setFieldErrors(null);
  }, [field.errors, isValid]);
  return /*#__PURE__*/_react.default.createElement(ContainerActions, {
    $caseIndexes: caseActionIndexes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 5
    }
  }, fieldErrors ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FieldErrorsContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _translations.FORM_ERRORS_TITLE,
    color: "danger",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_reactMarkdown.default, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 15
    }
  }, fieldErrors))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 11
    }
  })) : null, actionForm);
};
exports.RuleActionsField = RuleActionsField;