"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LastEventTime = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _last_event_time = require("../../containers/events/last_event_time");
var _empty_value = require("../empty_value");
var _formatted_date = require("../formatted_date");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/last_event_time/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LastEventTime = exports.LastEventTime = /*#__PURE__*/(0, _react.memo)(({
  hostName,
  userName,
  indexKey,
  ip,
  indexNames
}) => {
  const [loading, {
    lastSeen,
    errorMessage
  }] = (0, _last_event_time.useTimelineLastEventTime)({
    indexKey,
    indexNames,
    details: {
      hostName,
      ip,
      userName
    }
  });
  if (errorMessage != null) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      position: "top",
      content: errorMessage,
      "aria-label": "last_event_time_error",
      id: `last_event_time_error-${indexKey}`,
      type: "warning",
      iconProps: {
        'data-test-subj': 'last_event_time_error'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 9
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, loading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 21
    }
  }), !loading && lastSeen != null && new Date(lastSeen).toString() === 'Invalid Date' ? lastSeen : !loading && lastSeen != null && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.headerPage.pageSubtitle",
    defaultMessage: "Last event: {beat}",
    values: {
      beat: /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
        value: lastSeen,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 25
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 15
    }
  }), !loading && lastSeen == null && (0, _empty_value.getEmptyTagValue)());
});
LastEventTime.displayName = 'LastEventTime';