"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ItemDetailsPropertySummary = exports.ItemDetailsCard = exports.ItemDetailsAction = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/item_details_card/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OTHER_NODES = {};
const groupChildrenByType = (children, types) => {
  const result = new Map();
  types.forEach(type => result.set(type, []));
  result.set(OTHER_NODES, []);
  _react.default.Children.toArray(children).forEach(child => {
    const key = /*#__PURE__*/(0, _react.isValidElement)(child) ? child.type : OTHER_NODES;
    if (!result.has(key)) {
      var _result$get;
      (_result$get = result.get(OTHER_NODES)) === null || _result$get === void 0 ? void 0 : _result$get.push(child);
    } else {
      var _result$get2;
      (_result$get2 = result.get(key)) === null || _result$get2 === void 0 ? void 0 : _result$get2.push(child);
    }
  });
  return result;
};
const SummarySection = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  background-color: ${({
  theme
}) => theme.eui.euiColorLightestShade};
  padding: ${({
  theme
}) => theme.eui.euiSize};
`;
const DetailsSection = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  &&& {
    margin-left: 0;
  }
  padding: ${({
  theme
}) => theme.eui.euiSizeM} ${({
  theme
}) => theme.eui.euiSizeL}
    ${({
  theme
}) => theme.eui.euiSizeL} 0;
  .trustedAppsConditionsTable {
    margin-left: ${({
  theme
}) => theme.eui.euiSize};
  }
`;
const DescriptionListTitle = (0, _styledComponents.default)(_eui.EuiDescriptionListTitle)`
  &&& {
    width: 40%;
    margin-top: 0;
    margin-bottom: ${({
  theme
}) => theme.eui.euiSizeS};
  }
`;
const DescriptionListDescription = (0, _styledComponents.default)(_eui.EuiDescriptionListDescription)`
  &&& {
    width: 60%;
    margin-top: 0;
    margin-bottom: ${({
  theme
}) => theme.eui.euiSizeS};
  }
`;
const ItemDetailsPropertySummary = exports.ItemDetailsPropertySummary = /*#__PURE__*/(0, _react.memo)(({
  name,
  value
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(DescriptionListTitle, {
  className: "eui-textTruncate",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 86,
    columnNumber: 7
  }
}, name), /*#__PURE__*/_react.default.createElement(DescriptionListDescription, {
  className: "eui-textBreakWord",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 87,
    columnNumber: 7
  }
}, value)));
ItemDetailsPropertySummary.displayName = 'ItemPropertySummary';
const ItemDetailsAction = exports.ItemDetailsAction = /*#__PURE__*/(0, _react.memo)(({
  children,
  className = '',
  ...rest
}) => /*#__PURE__*/_react.default.createElement("div", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 96,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
  className: `eui-fullWidth ${className}`
}, rest, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 97,
    columnNumber: 7
  }
}), children)));
ItemDetailsAction.displayName = 'ItemDetailsAction';
const ItemDetailsCard = exports.ItemDetailsCard = /*#__PURE__*/(0, _react.memo)(({
  children,
  'data-test-subj': dataTestSubj,
  className
}) => {
  var _childElements$get;
  const childElements = (0, _react.useMemo)(() => groupChildrenByType(children, [ItemDetailsPropertySummary, ItemDetailsAction]), [children]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    "data-test-subj": dataTestSubj,
    className: className,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(SummarySection, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    type: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }, childElements.get(ItemDetailsPropertySummary))), /*#__PURE__*/_react.default.createElement(DetailsSection, {
    grow: 5,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 17
    }
  }, childElements.get(OTHER_NODES))), childElements.has(ItemDetailsAction) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 19
    }
  }, (_childElements$get = childElements.get(ItemDetailsAction)) === null || _childElements$get === void 0 ? void 0 : _childElements$get.map((action, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 23
    }
  }, action))))))));
});
ItemDetailsCard.displayName = 'ItemDetailsCard';