"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterByAssigneesPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_license = require("../../hooks/use_license");
var _use_upselling = require("../../hooks/use_upselling");
var _constants = require("../assignees/constants");
var _assignees_selectable = require("../assignees/assignees_selectable");
var _test_ids = require("./test_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/filter_by_assignees_popover/filter_by_assignees_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * The popover to filter alerts by assigned users
 */
const FilterByAssigneesPopover = exports.FilterByAssigneesPopover = /*#__PURE__*/(0, _react.memo)(({
  selectedUserIds,
  onSelectionChange
}) => {
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const upsellingMessage = (0, _use_upselling.useUpsellingMessage)('alert_assignments');
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setIsPopoverOpen(value => !value), []);
  const searchInputId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'searchInput'
  });
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: upsellingMessage !== null && upsellingMessage !== void 0 ? upsellingMessage : _i18n.i18n.translate('xpack.securitySolution.filtersGroup.assignees.popoverTooltip', {
      defaultMessage: 'Filter by assignee'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    "data-test-subj": _test_ids.FILTER_BY_ASSIGNEES_BUTTON,
    iconType: "arrowDown",
    badgeColor: "subdued",
    disabled: !isPlatinumPlus,
    onClick: togglePopover,
    isSelected: isPopoverOpen,
    hasActiveFilters: selectedUserIds.length > 0,
    numActiveFilters: selectedUserIds.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.securitySolution.filtersGroup.assignees.buttonTitle', {
    defaultMessage: 'Assignees'
  }))), [isPlatinumPlus, isPopoverOpen, selectedUserIds.length, togglePopover, upsellingMessage]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "none",
    initialFocus: `[id="${searchInputId}"]`,
    button: button,
    isOpen: isPopoverOpen,
    panelStyle: {
      minWidth: _constants.ASSIGNEES_PANEL_WIDTH
    },
    closePopover: togglePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_assignees_selectable.AssigneesSelectable, {
    searchInputId: searchInputId,
    assignedUserIds: selectedUserIds,
    showUnassignedOption: true,
    onSelectionChange: onSelectionChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  })));
});
FilterByAssigneesPopover.displayName = 'FilterByAssigneesPopover';