"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tooltipContentIsExplicitlyNull = exports.getDefaultWhenTooltipIsUnspecified = exports.DraggableBadge = exports.DefaultDraggable = exports.Content = exports.Badge = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _draggable_wrapper = require("../drag_and_drop/draggable_wrapper");
var _helpers = require("../drag_and_drop/helpers");
var _empty_value = require("../empty_value");
var _data_provider = require("../../../timelines/components/timeline/data_providers/data_provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/draggables/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Only returns true if the specified tooltipContent is exactly `null`.
 * Example input / output:
 * `bob -> false`
 * `undefined -> false`
 * `<span>thing</span> -> false`
 * `null -> true`
 */
const tooltipContentIsExplicitlyNull = tooltipContent => tooltipContent === null; // an explicit / exact null check

/**
 * Derives the tooltip content from the field name if no tooltip was specified
 */
exports.tooltipContentIsExplicitlyNull = tooltipContentIsExplicitlyNull;
const getDefaultWhenTooltipIsUnspecified = ({
  field,
  tooltipContent
}) => tooltipContent != null ? tooltipContent : field;

/**
 * Renders the content of the draggable, wrapped in a tooltip
 */
exports.getDefaultWhenTooltipIsUnspecified = getDefaultWhenTooltipIsUnspecified;
const Content = exports.Content = /*#__PURE__*/_react.default.memo(({
  children,
  field,
  tooltipContent,
  tooltipPosition,
  value
}) => !tooltipContentIsExplicitlyNull(tooltipContent) ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  "data-test-subj": `${field}-tooltip`,
  position: tooltipPosition,
  content: getDefaultWhenTooltipIsUnspecified({
    tooltipContent,
    field
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 69,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children ? children : value)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children ? children : value));
Content.displayName = 'Content';

/**
 * Draggable text (or an arbitrary visualization specified by `children`)
 * that's only displayed when the specified value is non-`null`.
 *
 * @param id - a unique draggable id, which typically follows the format `${contextId}-${eventId}-${field}-${value}`
 * @param field - the name of the field, e.g. `network.transport`
 * @param value - value of the field e.g. `tcp`
 * @param name - defaulting to `field`, this optional human readable name is used by the `DataProvider` that represents the data
 * @param children - defaults to displaying `value`, this allows an arbitrary visualization to be displayed in lieu of the default behavior
 * @param tooltipContent - defaults to displaying `field`, pass `null` to
 * prevent a tooltip from being displayed, or pass arbitrary content
 * @param tooltipPosition - defaults to eui's default tooltip position
 * @param queryValue - defaults to `value`, this query overrides the `queryMatch.value` used by the `DataProvider` that represents the data
 * @param hideTopN - defaults to `false`, when true, the option to aggregate this field will be hidden
 */
const DefaultDraggable = exports.DefaultDraggable = /*#__PURE__*/_react.default.memo(({
  hideTopN = false,
  id,
  field,
  fieldType = '',
  isAggregatable = false,
  value,
  name,
  children,
  scopeId,
  tooltipContent,
  tooltipPosition,
  queryValue,
  truncate
}) => {
  const dataProviderProp = (0, _react.useMemo)(() => {
    var _value$toString;
    return {
      and: [],
      enabled: true,
      id: (0, _helpers.escapeDataProviderId)(id),
      name: name ? name : (_value$toString = value === null || value === void 0 ? void 0 : value.toString()) !== null && _value$toString !== void 0 ? _value$toString : '',
      excluded: false,
      kqlQuery: '',
      queryMatch: {
        field,
        value: queryValue ? queryValue : value !== null && value !== void 0 ? value : '',
        operator: _data_provider.IS_OPERATOR
      }
    };
  }, [field, id, name, queryValue, value]);
  const renderCallback = (0, _react.useCallback)(() => /*#__PURE__*/_react.default.createElement(Content, {
    field: field,
    tooltipContent: tooltipContent,
    tooltipPosition: tooltipPosition,
    value: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }, children), [children, field, tooltipContent, tooltipPosition, value]);
  if (value == null) return null;
  return /*#__PURE__*/_react.default.createElement(_draggable_wrapper.DraggableWrapper, {
    dataProvider: dataProviderProp,
    fieldType: fieldType,
    isAggregatable: isAggregatable,
    hideTopN: hideTopN,
    render: renderCallback,
    scopeId: scopeId,
    truncate: truncate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  });
});
DefaultDraggable.displayName = 'DefaultDraggable';
const Badge = exports.Badge = (0, _styled.default)(_eui.EuiBadge)`
  vertical-align: top;
`;
Badge.displayName = 'Badge';
/**
 * A draggable badge that's only displayed when the specified value is non-`null`.
 *
 * @param contextId - used as part of the formula to derive a unique draggable id, this describes the context e.g. `event-fields-browser` in which the badge is displayed
 * @param eventId - uniquely identifies an event, as specified in the `_id` field of the document
 * @param field - the name of the field, e.g. `network.transport`
 * @param value - value of the field e.g. `tcp`
 * @param iconType -the (optional) type of icon e.g. `snowflake` to display on the badge
 * @param name - defaulting to `field`, this optional human readable name is used by the `DataProvider` that represents the data
 * @param children - defaults to displaying `value`, this allows an arbitrary visualization to be displayed in lieu of the default behavior
 * @param tooltipContent - defaults to displaying `field`, pass `null` to
 * prevent a tooltip from being displayed, or pass arbitrary content
 * @param queryValue - defaults to `value`, this query overrides the `queryMatch.value` used by the `DataProvider` that represents the data
 */
const DraggableBadgeComponent = ({
  contextId,
  eventId,
  field,
  value,
  iconType,
  isAggregatable,
  fieldType,
  name,
  children,
  scopeId,
  tooltipContent,
  queryValue
}) => value != null ? /*#__PURE__*/_react.default.createElement(DefaultDraggable, {
  id: `draggable-badge-default-draggable-${contextId}-${eventId}-${field}-${value}`,
  isAggregatable: isAggregatable,
  fieldType: fieldType,
  field: field,
  name: name,
  value: value,
  scopeId: scopeId,
  tooltipContent: tooltipContent,
  queryValue: queryValue,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 204,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(Badge, {
  iconType: iconType,
  color: "hollow",
  title: "",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 215,
    columnNumber: 7
  }
}, children ? children : value !== '' ? value : (0, _empty_value.getEmptyStringTag)())) : null;
DraggableBadgeComponent.displayName = 'DraggableBadgeComponent';
const DraggableBadge = exports.DraggableBadge = /*#__PURE__*/_react.default.memo(DraggableBadgeComponent);
DraggableBadge.displayName = 'DraggableBadge';