"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CellActionsWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../../common/types");
var _cell_actions = require("../cell_actions");
var _helpers = require("../../../helpers");
var _context = require("../../../timelines/components/timeline/context");
var _shared = require("../events_viewer/shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/drag_and_drop/cell_actions_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CellActionsWrapper = exports.CellActionsWrapper = /*#__PURE__*/_react.default.memo(({
  dataProvider,
  scopeId = _types.TimelineId.active,
  children,
  hideTopN = false
}) => {
  const {
    timelineId: timelineIdFind
  } = (0, _react.useContext)(_context.TimelineContext);
  const {
    tableId: tableIdFind
  } = (0, _react.useContext)(_shared.TableContext);
  const sourcererScopeId = (0, _react.useMemo)(() => {
    var _ref;
    return (0, _helpers.getSourcererScopeId)((_ref = scopeId !== null && scopeId !== void 0 ? scopeId : timelineIdFind) !== null && _ref !== void 0 ? _ref : tableIdFind);
  }, [scopeId, tableIdFind, timelineIdFind]);
  const data = (0, _react.useMemo)(() => {
    const {
      value,
      field
    } = dataProvider.queryMatch;
    return {
      value: value || [],
      field
    };
  }, [dataProvider.queryMatch]);
  const disabledActionTypes = (0, _react.useMemo)(() => hideTopN ? [_cell_actions.SecurityCellActionType.SHOW_TOP_N] : [], [hideTopN]);
  return /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
    mode: _cell_actions.CellActionsMode.HOVER_DOWN,
    visibleCellActions: 6,
    showActionTooltips: true,
    triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
    data: data,
    disabledActionTypes: disabledActionTypes,
    sourcererScopeId: sourcererScopeId,
    metadata: {
      scopeId
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, children);
});
CellActionsWrapper.displayName = 'CellActionsWrapper';