"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEnableColumn = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _missing_privileges = require("../../missing_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/settings_flyout/schedule/schedules_table/columns/enable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EnableSwitch = ({
  enabled,
  isDisabled,
  isLoading,
  onSwitchChange,
  scheduleId
}) => {
  const [myIsLoading, setMyIsLoading] = (0, _react.useState)(false);
  const onScheduleStateChange = (0, _react.useCallback)(async event => {
    setMyIsLoading(true);
    await onSwitchChange(scheduleId, !enabled);
    setMyIsLoading(false);
  }, [enabled, onSwitchChange, scheduleId]);
  const showLoader = (0, _react.useMemo)(() => {
    if (myIsLoading !== isLoading) {
      return isLoading || myIsLoading;
    }
    return myIsLoading;
  }, [myIsLoading, isLoading]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceAround",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, showLoader ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    "data-test-subj": "scheduleSwitchLoader",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_missing_privileges.WithMissingPrivileges, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, canUpdateSchedule => /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "scheduleSwitch",
    showLabel: false,
    label: "",
    disabled: isDisabled || !canUpdateSchedule,
    checked: enabled,
    onChange: onScheduleStateChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 15
    }
  }))));
};
const createEnableColumn = ({
  isDisabled,
  isLoading,
  onSwitchChange
}) => {
  return {
    field: 'enabled',
    name: i18n.COLUMN_ENABLE,
    render: (_, schedule) => /*#__PURE__*/_react.default.createElement(EnableSwitch, {
      enabled: schedule.enabled,
      isDisabled: isDisabled,
      isLoading: isLoading,
      onSwitchChange: onSwitchChange,
      scheduleId: schedule.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 7
      }
    }),
    width: '65px',
    align: 'center'
  };
};
exports.createEnableColumn = createEnableColumn;