"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createActionsColumn = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _missing_privileges = require("../../missing_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/settings_flyout/schedule/schedules_table/columns/actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Action = ({
  isDisabled,
  deleteSchedule,
  scheduleId
}) => {
  const onScheduleDeleteChange = (0, _react.useCallback)(async () => {
    deleteSchedule(scheduleId);
  }, [deleteSchedule, scheduleId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceAround",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_missing_privileges.WithMissingPrivileges, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 9
    }
  }, enabled => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "deleteButton",
    "aria-label": i18n.DELETE_ACTIONS_BUTTON_ARIAL_LABEL,
    color: "danger",
    iconType: "trash",
    onClick: onScheduleDeleteChange,
    disabled: isDisabled || !enabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 13
    }
  }))));
};
const createActionsColumn = ({
  isDisabled,
  deleteSchedule
}) => {
  return {
    field: 'delete',
    name: i18n.COLUMN_ACTIONS,
    render: (_, schedule) => /*#__PURE__*/_react.default.createElement(Action, {
      isDisabled: isDisabled,
      deleteSchedule: deleteSchedule,
      scheduleId: schedule.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 7
      }
    }),
    width: '65px',
    align: 'center'
  };
};
exports.createActionsColumn = createActionsColumn;